/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.content.DiffSegment;
import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestDiffLine;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=DiffSegment.class)
public class RestDiffSegment
extends RestMapEntity {
    public static final Function<DiffSegment, RestDiffSegment> REST_TRANSFORM = new Function<DiffSegment, RestDiffSegment>(){

        public RestDiffSegment apply(DiffSegment segment) {
            return new RestDiffSegment(segment);
        }
    };
    public static final RestDiffSegment REMOVED_SOURCE_EXAMPLE = new RestDiffSegment(DiffSegmentType.REMOVED, Lists.newArrayList((Object[])new RestDiffLine[]{RestDiffLine.SOURCE_EXAMPLE}), false);
    public static final RestDiffSegment ADDED_DEST_EXAMPLE = new RestDiffSegment(DiffSegmentType.ADDED, Lists.newArrayList((Object[])new RestDiffLine[]{RestDiffLine.DESTINATION_EXAMPLE, RestDiffLine.DESTINATION_2_EXAMPLE}), false);
    public static final RestDiffSegment ADDED_DEST_EXAMPLE_COMMENTED = new RestDiffSegment(DiffSegmentType.ADDED, Lists.newArrayList((Object[])new RestDiffLine[]{RestDiffLine.DESTINATION_EXAMPLE_WITH_COMMENTS, RestDiffLine.DESTINATION_2_EXAMPLE}), false);

    public RestDiffSegment() {
    }

    public RestDiffSegment(DiffSegment segment) {
        this(segment.getType(), RestDiffSegment.transform(segment.getLines(), RestDiffLine.REST_TRANSFORM), segment.isTruncated());
    }

    private RestDiffSegment(DiffSegmentType type, List<RestDiffLine> lines, boolean truncated) {
        this.putIfNotNull("type", type);
        this.putIfNotNull("lines", lines);
        this.putIfNotNull("truncated", truncated);
    }
}

