/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.scheduler.core.RunningJob;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SchedulerLifecycle
extends AbstractSmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(SchedulerLifecycle.class);
    private static final Function<RunningJob, JobId> TO_JOB_ID = new Function<RunningJob, JobId>(){

        public JobId apply(RunningJob runningJob) {
            return runningJob.getJobId();
        }
    };
    private final LifecycleAwareSchedulerService schedulerService;
    private final int shutdownTimeout;

    @Autowired
    public SchedulerLifecycle(LifecycleAwareSchedulerService schedulerService, @Value(value="${scheduler.shutdown.timeout}") int shutdownTimeout) {
        this.schedulerService = schedulerService;
        this.shutdownTimeout = shutdownTimeout;
    }

    public int getPhase() {
        return 1000;
    }

    @Override
    public void start() {
        try {
            this.schedulerService.start();
            super.start();
        }
        catch (SchedulerServiceException e) {
            throw new IllegalStateException("The scheduler could not be started", e);
        }
    }

    @Override
    public void stop() {
        this.schedulerService.shutdown();
        try {
            if (!this.schedulerService.waitUntilIdle((long)this.shutdownTimeout, TimeUnit.SECONDS)) {
                log.debug("Scheduler service is not idle after {} seconds.", (Object)this.shutdownTimeout);
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted while waiting for running jobs to complete.", (Throwable)e);
        }
        Collection locallyRunningJobs = this.schedulerService.getLocallyRunningJobs();
        if (!locallyRunningJobs.isEmpty()) {
            log.warn("The following jobs could not be canceled. They will be killed when the JVM terminates: {}", (Object)Iterables.transform((Iterable)locallyRunningJobs, TO_JOB_ID));
        }
        super.stop();
    }
}

