/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.process;

import com.atlassian.stash.internal.process.ExternalProcessConfigurer;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.utils.process.ExternalProcessImpl;
import com.atlassian.utils.process.ExternalProcessSettings;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteUserExternalProcessConfigurer
implements ExternalProcessConfigurer {
    private final StashAuthenticationContext authenticationContext;

    @Autowired
    public RemoteUserExternalProcessConfigurer(StashAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Override
    public void configure(@Nonnull ExternalProcessImpl process, @Nonnull ExternalProcessSettings settings) {
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            settings.getEnvironment().put("REMOTE_USER", user.getName());
        }
    }
}

