/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.scan;

import com.atlassian.stash.content.SimplePath;
import com.atlassian.stash.internal.plugin.PluginPathScanner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClassLoaderPluginPathScanner
implements PluginPathScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderPluginPathScanner.class);
    private final ClassLoader classLoader;

    public ClassLoaderPluginPathScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Iterable<String> getPaths(String directoryToScan) {
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver(this.classLoader).getResources("classpath*:" + SimplePath.join((String)directoryToScan, (String)"**"));
            ArrayList paths = Lists.newArrayListWithExpectedSize((int)resources.length);
            for (Resource resource : resources) {
                String path = resource.getURI().toString();
                int i = directoryToScan.length() == 1 ? path.lastIndexOf(47) : path.indexOf(directoryToScan);
                paths.add(path.substring(i));
            }
            return paths;
        }
        catch (IOException e) {
            log.error("Error scanning classpath {} in {}", new Object[]{this.classLoader, directoryToScan, e});
            return Lists.newArrayList();
        }
    }
}

