/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ScanningClassPathPluginLoader
implements PluginLoader {
    public static final String DEFAULT_PATTERN = "**/*.xml";
    private static final Logger log = LoggerFactory.getLogger(ScanningClassPathPluginLoader.class);
    private final ResourcePatternResolver resourcePatternResolver;
    private final String locationPattern;
    private List<Plugin> plugins;

    public ScanningClassPathPluginLoader(String basePath) {
        this(basePath, DEFAULT_PATTERN);
    }

    public ScanningClassPathPluginLoader(String basePath, String pattern) {
        this(basePath, pattern, (ResourcePatternResolver)new PathMatchingResourcePatternResolver());
    }

    public ScanningClassPathPluginLoader(String basePath, String pattern, ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
        this.locationPattern = "classpath*:" + basePath + "/" + pattern;
    }

    public Collection<Plugin> loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        if (this.plugins == null) {
            this.plugins = this.findAllPlugins(moduleDescriptorFactory);
        }
        return this.plugins;
    }

    public Iterable<Plugin> loadFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        return Collections.emptyList();
    }

    private List<Plugin> findAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        try {
            for (Resource resource : this.resourcePatternResolver.getResources(this.locationPattern)) {
                Iterables.addAll(plugins, (Iterable)new SinglePluginLoader(resource.getURL()).loadAllPlugins(moduleDescriptorFactory));
            }
        }
        catch (IOException e) {
            log.error("Failed to load plugins from classpath matching pattern: " + this.locationPattern, (Throwable)e);
        }
        return plugins;
    }

    public boolean supportsAddition() {
        return false;
    }

    public boolean supportsRemoval() {
        return false;
    }

    public void removePlugin(Plugin plugin) throws PluginException {
        throw new UnsupportedOperationException();
    }

    public boolean isDynamicPluginLoader() {
        return false;
    }
}

