/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.module.PrefixDelegatingModuleFactory;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class OsgiSafeProxyProvider {
    private static final Set<Class<?>> CLASS_PROXY_REQUIRED = Sets.newHashSet((Object[])new Class[]{PrefixDelegatingModuleFactory.class});
    private static final Logger log = LoggerFactory.getLogger(OsgiSafeProxyProvider.class);
    private final ApplicationContext applicationContext;
    private final Map<Class<?>, Object> proxies;
    private volatile boolean initialized;

    @Autowired
    public OsgiSafeProxyProvider(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.proxies = Maps.newConcurrentMap();
    }

    public Object proxy(Object value, Class<?> type) {
        if (!this.shouldProxy(type)) {
            return value;
        }
        this.maybeInitialize();
        if (type.isArray()) {
            int length = Array.getLength(value);
            Object arr = Array.newInstance(type.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(arr, i, this.proxy(Array.get(value, i), type.getComponentType()));
            }
            return arr;
        }
        Object proxy = this.proxies.get(type);
        return proxy == null ? this.createNewProxy(value, type) : proxy;
    }

    public Object[] proxy(Object[] values, Class<?>[] parameterTypes) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.proxy(values[i], parameterTypes[i]);
        }
        return result;
    }

    @VisibleForTesting
    protected void register(Object proxy, Class<?> ... implementedInterfaces) {
        for (Class<?> type : implementedInterfaces) {
            this.proxies.put(type, proxy);
        }
    }

    private Object createNewProxy(final Object value, Class<?> type) {
        ProxyFactory factory = new ProxyFactory(value);
        if (!type.isInterface() || CLASS_PROXY_REQUIRED.contains(value.getClass())) {
            factory.setProxyTargetClass(true);
        }
        factory.addAdvice((Advice)new MethodInterceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(MethodInvocation invocation) throws Throwable {
                Thread currentThread = Thread.currentThread();
                ClassLoader original = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(value.getClass().getClassLoader());
                    Object object = invocation.proceed();
                    return object;
                }
                finally {
                    currentThread.setContextClassLoader(original);
                }
            }
        });
        try {
            return factory.getProxy();
        }
        catch (RuntimeException e) {
            log.debug("Error creating OSGI safe proxy. Returning unproxied bean instead.", (Throwable)e);
            return value;
        }
    }

    private Object getOsgiProxyFor(OsgiContainerManager osgiContainerManager, HostComponentRegistration registration) {
        for (Class mainInterface : registration.getMainInterfaceClasses()) {
            try {
                Object service = osgiContainerManager.getServiceTracker(mainInterface.getName()).waitForService(1L);
                if (!this.isInstanceOfAll(service, registration.getMainInterfaceClasses())) continue;
                return service;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    private boolean isInstanceOfAll(Object value, Class<?> ... types) {
        if (value == null) {
            return false;
        }
        for (Class<?> clazz : types) {
            if (clazz.isAssignableFrom(value.getClass())) continue;
            return false;
        }
        return true;
    }

    private void maybeInitialize() {
        if (this.initialized) {
            return;
        }
        try {
            ConfigurableListableBeanFactory parentContext = (ConfigurableListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
            OsgiContainerManager osgiManager = (OsgiContainerManager)parentContext.getBean(OsgiContainerManager.class);
            for (HostComponentRegistration registration : osgiManager.getHostComponentRegistrations()) {
                Object osgiProxy;
                if (CLASS_PROXY_REQUIRED.contains(registration.getInstance().getClass()) || (osgiProxy = this.getOsgiProxyFor(osgiManager, registration)) == null) continue;
                this.register(osgiProxy, registration.getMainInterfaceClasses());
            }
            this.initialized = true;
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private boolean shouldProxy(Class<?> type) {
        String fqn = type.getName();
        return !fqn.startsWith("javax.") && !fqn.startsWith("java.");
    }
}

