/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.stash.internal.plugin.CachingPluginSettings;
import com.atlassian.stash.internal.plugin.ContextClassLoaderSettingInvocationHandler;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import com.atlassian.stash.internal.plugin.PluginSettingKey;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="pluginSettingsFactory")
@AvailableToPlugins(value=PluginSettingsFactory.class)
public class CachingPluginSettingsFactoryImpl
implements PluginSettingsFactory {
    public static final String GLOBAL_SETTING_NAMESPACE = "stash.global.settings";
    private static final Logger log = LoggerFactory.getLogger(CachingPluginSettingsFactoryImpl.class);
    private static final int DEFAULT_MAX = 500;
    private static final int DEFAULT_TTL = 3600;
    private static final String PROPERTY_PREFIX = "cache.com.atlassian.stash.internal.plugin.PluginSetting.";
    private static final String PROPERTY_MAX = "cache.com.atlassian.stash.internal.plugin.PluginSetting.max";
    private static final String PROPERTY_TTL = "cache.com.atlassian.stash.internal.plugin.PluginSetting.ttl";
    private final Cache<PluginSettingKey, Option<Object>> cache;
    private final LoadingCache<String, PluginSettings> settingsForKey;
    private PluginSettings globalSettings;

    @Autowired
    public CachingPluginSettingsFactoryImpl(CacheFactory cacheFactory, final PluginSettingDao pluginSettingDao, PlatformTransactionManager transactionManager, @Value(value="${cache.com.atlassian.stash.internal.plugin.PluginSetting.max}") String maxEntries, @Value(value="${cache.com.atlassian.stash.internal.plugin.PluginSetting.ttl}") String timeToLiveSeconds) {
        final TransactionTemplate readOnly = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0, (boolean)true));
        final TransactionTemplate readWrite = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0));
        this.cache = cacheFactory.getCache(this.getClass().getSimpleName(), null, new CacheSettingsBuilder().expireAfterWrite((long)this.toInt(PROPERTY_TTL, timeToLiveSeconds, 3600), TimeUnit.SECONDS).maxEntries(this.toInt(PROPERTY_MAX, maxEntries, 500)).remote().replicateViaInvalidation().build());
        this.settingsForKey = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, PluginSettings>(){

            public PluginSettings load(@Nonnull String namespace) throws Exception {
                return (PluginSettings)Proxy.newProxyInstance(PluginSettings.class.getClassLoader(), new Class[]{PluginSettings.class}, (InvocationHandler)new ContextClassLoaderSettingInvocationHandler((Object)new CachingPluginSettings((Cache<PluginSettingKey, Option<Object>>)CachingPluginSettingsFactoryImpl.this.cache, pluginSettingDao, namespace, readOnly, readWrite)));
            }
        });
    }

    public PluginSettings createGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = (PluginSettings)this.settingsForKey.apply((Object)GLOBAL_SETTING_NAMESPACE);
        }
        return this.globalSettings;
    }

    public PluginSettings createSettingsForKey(String key) {
        try {
            return (PluginSettings)this.settingsForKey.getUnchecked((Object)key);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private int toInt(String settingName, String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.warn("Error reading {} setting. Falling back to default value {}", new Object[]{settingName, defaultValue, e});
            return defaultValue;
        }
    }
}

