/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.Supplier;
import com.atlassian.fugue.Option;
import com.atlassian.sal.core.pluginsettings.AbstractStringPluginSettings;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import com.atlassian.stash.internal.plugin.PluginSettingKey;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class CachingPluginSettings
extends AbstractStringPluginSettings {
    private static final Logger log = LoggerFactory.getLogger(CachingPluginSettings.class);
    private final Cache<PluginSettingKey, Option<Object>> cache;
    private final PluginSettingDao dao;
    private final String namespace;
    private final TransactionTemplate readOnly;
    private final TransactionTemplate readWrite;

    public CachingPluginSettings(Cache<PluginSettingKey, Option<Object>> cache, PluginSettingDao dao, String namespace, TransactionTemplate readOnly, TransactionTemplate readWrite) {
        this.cache = cache;
        this.dao = dao;
        this.namespace = namespace;
        this.readOnly = readOnly;
        this.readWrite = readWrite;
    }

    public Object get(final String key) {
        PluginSettingKey cacheKey = new PluginSettingKey(this.namespace, key);
        try {
            Option cached = (Option)this.cache.get((Object)cacheKey, (Supplier)new Supplier<Option<Object>>(){

                public Option<Object> get() {
                    log.trace("PluginSettings: Cache miss for {}::{}", (Object)CachingPluginSettings.this.namespace, (Object)key);
                    return Option.option((Object)CachingPluginSettings.super.get(key));
                }
            });
            return this.copy(cached.getOrNull());
        }
        catch (CacheException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    protected String getActual(final String key) {
        return (String)this.readOnly.execute((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction(TransactionStatus status) {
                return CachingPluginSettings.this.dao.get(CachingPluginSettings.this.namespace, key);
            }
        });
    }

    protected void putActual(final String key, final String val) {
        this.readWrite.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                if (StringUtils.isEmpty((String)val)) {
                    CachingPluginSettings.this.dao.remove(CachingPluginSettings.this.namespace, key);
                } else {
                    CachingPluginSettings.this.dao.put(CachingPluginSettings.this.namespace, key, val);
                }
                CachingPluginSettings.this.invalidateEntry(CachingPluginSettings.this.namespace, key);
                return null;
            }
        });
    }

    protected void removeActual(final String key) {
        this.readWrite.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                CachingPluginSettings.this.dao.remove(CachingPluginSettings.this.namespace, key);
                CachingPluginSettings.this.invalidateEntry(CachingPluginSettings.this.namespace, key);
                return null;
            }
        });
    }

    private Object copy(Object value) {
        if (value == null || value instanceof String) {
            return value;
        }
        if (value instanceof List) {
            return Lists.newArrayList((Iterable)((List)value));
        }
        if (value instanceof Properties) {
            Properties result = new Properties();
            result.putAll((Map<?, ?>)((Properties)value));
            return result;
        }
        if (value instanceof Map) {
            return Maps.newHashMap((Map)((Map)value));
        }
        throw new IllegalArgumentException(value.getClass().toString() + " is not supported");
    }

    private void invalidateEntry(final String namespace, final String key) {
        SpringTransactionUtils.invokeAfterCommit((Runnable)new Runnable(){

            @Override
            public void run() {
                CachingPluginSettings.this.cache.remove((Object)new PluginSettingKey(namespace, key));
                log.trace("PluginSettings: Cache invalidation for {}::{}", (Object)namespace, (Object)key);
            }
        });
    }
}

