/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClasspathI18nMessageSource
extends ResourceBundleMessageSource {
    public ClasspathI18nMessageSource() throws IOException {
        Collection baseNames = Collections2.filter((Collection)Collections2.transform(Arrays.asList(new PathMatchingResourcePatternResolver().getResources("classpath*:/i18n/stash-*.properties")), (Function)new Function<Resource, String>(){

            public String apply(Resource resource) {
                String name = resource.getFilename();
                return "i18n/" + name.substring(0, name.length() - ".properties".length());
            }
        }), (Predicate)Predicates.notNull());
        if (!baseNames.isEmpty()) {
            this.setBasenames(baseNames.toArray(new String[baseNames.size()]));
        }
    }

    private String getPath(Resource resource) {
        String path = null;
        try {
            path = resource.getURI().getPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }
}

