/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.CompositeTransferableState;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StateTransferringExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(StateTransferringExecutor.class);
    private final Executor delegate;
    private List<StatefulService> services;

    public StateTransferringExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(@Nonnull Runnable runnable) {
        this.delegate.execute(this.wrap(runnable));
    }

    @Autowired
    public void setServices(StatefulService ... services) {
        this.services = ImmutableList.copyOf((Object[])services);
    }

    protected void clearServices() {
        this.services = ImmutableList.of();
    }

    protected TransferableState getState() {
        return new CompositeTransferableState(Collections2.transform(this.services, StatefulService.TO_STATE));
    }

    protected Runnable wrap(Runnable runnable) {
        return new StateTransferringRunnable(runnable, this.getState());
    }

    protected static class StateTransferringRunnable
    implements Runnable {
        private final Runnable delegate;
        private final TransferableState state;

        public StateTransferringRunnable(Runnable delegate, TransferableState state) {
            this.delegate = delegate;
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.state.apply();
                try {
                    this.delegate.run();
                }
                finally {
                    this.state.remove();
                }
            }
            catch (RuntimeException e) {
                log.error("Error while processing asynchronous task", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                log.error("Error while processing asynchronous task", (Throwable)e);
                throw e;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateTransferringRunnable)) {
                return false;
            }
            StateTransferringRunnable that = (StateTransferringRunnable)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

