/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.security.auth.trustedapps.filter.AuthenticationController;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.StashAuthenticationContext;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrustedApplicationsAuthController
implements AuthenticationController {
    private final StashAuthenticationContext authenticationContext;
    private final LicenseService licenseService;

    @Autowired
    public TrustedApplicationsAuthController(StashAuthenticationContext authenticationContext, LicenseService licenseService) {
        this.authenticationContext = authenticationContext;
        this.licenseService = licenseService;
    }

    public boolean shouldAttemptAuthentication(HttpServletRequest request) {
        return !this.authenticationContext.isAuthenticated();
    }

    public boolean canLogin(Principal principal, HttpServletRequest request) {
        return this.licenseService.canLogin(principal);
    }
}

