/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.google.common.base.Throwables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;

@Component
public class SchedulerLifecycle
implements SmartLifecycle {
    private final LifecycleAwareSchedulerService schedulerService;
    private volatile boolean running;

    @Autowired
    public SchedulerLifecycle(LifecycleAwareSchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        try {
            this.schedulerService.start();
            this.running = true;
        }
        catch (SchedulerServiceException e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void stop() {
        try {
            this.schedulerService.standby();
        }
        catch (SchedulerServiceException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

