/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.stash.internal.plugin.web.fragments.ClientPageDataHandler;
import com.atlassian.stash.internal.plugin.web.fragments.PageDataProviderModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.PageDataUtils;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestCacheClientPageDataHandler
implements ClientPageDataHandler {
    private PluginAccessor pluginAccessor;
    private final WebResourceIntegration webResourceIntegration;
    private final StashAuthenticationContext authenticationContext;
    private final HttpContext httpContext;
    private static final Logger log = LoggerFactory.getLogger(RequestCacheClientPageDataHandler.class);
    private static final String PAGE_DATA_KEY = "page-data-plugin";

    @Autowired
    public RequestCacheClientPageDataHandler(PluginAccessor pluginAccessor, WebResourceIntegration webResourceIntegration, StashAuthenticationContext authenticationContext, HttpContext httpContext) {
        this.pluginAccessor = pluginAccessor;
        this.webResourceIntegration = webResourceIntegration;
        this.authenticationContext = authenticationContext;
        this.httpContext = httpContext;
    }

    private Map<String, Object> getPageData(String context, Map<String, Object> args) {
        HashMap<String, Object> pageDataByModuleKey = new HashMap<String, Object>();
        for (PageDataProviderModuleDescriptor descriptor : this.pluginAccessor.getEnabledModuleDescriptorsByClass(PageDataProviderModuleDescriptor.class)) {
            Map pageData;
            ContextProvider provider;
            if (!descriptor.getPageDataContexts().contains(context) || (provider = descriptor.getPageDataProvider()) == null || (pageData = provider.getContextMap(args)) == null) continue;
            pageDataByModuleKey.put(descriptor.getCompleteKey(), pageData);
        }
        return pageDataByModuleKey;
    }

    @Override
    public void requirePageData(String location, Map<String, Object> context) {
        Map<String, Map<String, Object>> pageDataByContext = this.getRequiredPageData();
        if (pageDataByContext.containsKey(location)) {
            log.debug("Context " + location + " was required already. Ignoring.");
            return;
        }
        HashMap newContext = Maps.newHashMap(context);
        newContext.put("request", this.httpContext.getRequest());
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            newContext.put("currentUser", user);
        }
        pageDataByContext.put(location, this.getPageData(location, newContext));
    }

    public Map<String, Map<String, Object>> getRequiredPageData() {
        HashMap pageDataByContext = (HashMap)this.webResourceIntegration.getRequestCache().get(PAGE_DATA_KEY);
        if (pageDataByContext == null) {
            pageDataByContext = new HashMap();
            this.webResourceIntegration.getRequestCache().put(PAGE_DATA_KEY, pageDataByContext);
        }
        return pageDataByContext;
    }

    @Override
    public String toPageDataScript() {
        return this.toPageDataScript(true);
    }

    public String toPageDataScript(boolean clearCache) {
        Map<String, Map<String, Object>> pageDataByContext = this.getRequiredPageData();
        StringWriter sw = new StringWriter();
        try {
            PageDataUtils.appendScriptTag(sw, pageDataByContext);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing page-data output to String.", e);
        }
        if (clearCache) {
            pageDataByContext.clear();
        }
        return sw.toString();
    }
}

