/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.web.fragments;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.plugin.web.descriptors.WeightedDescriptor;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.stash.internal.plugin.PreprocessedWebResourceModuleDescriptor;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentFieldType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebFragmentType;
import com.atlassian.stash.internal.plugin.web.fragments.ClientWebInterfaceManager;
import com.atlassian.stash.internal.plugin.web.fragments.PageDataProviderModuleDescriptor;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractClientWebFragmentModuleDescriptor
extends PreprocessedWebResourceModuleDescriptor
implements WeightedDescriptor,
PageDataProviderModuleDescriptor<Void> {
    private static final String CLIENT_WEB_FRAGMENT_MANAGER_MODULE_KEY = "com.atlassian.stash.stash-client-web-fragments-plugin:web-fragment-manager";
    private static final int DEFAULT_WEIGHT = 1000;
    private final ClientWebInterfaceManager clientWebInterfaceManager;
    private final ConditionElementParser conditionElementParser;
    private final WebFragmentHelper webFragmentHelper;
    private ContextProvider contextProvider;
    private String contextProviderClass;
    private Condition condition;
    private int weight;

    public AbstractClientWebFragmentModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer, ClientWebInterfaceManager clientWebInterfaceManager, ConditionElementParser.ConditionFactory conditionFactory, WebFragmentHelper webFragmentHelper) {
        super(moduleFactory, hostContainer);
        this.clientWebInterfaceManager = clientWebInterfaceManager;
        this.conditionElementParser = new ConditionElementParser(conditionFactory);
        this.webFragmentHelper = webFragmentHelper;
    }

    static void addClientWebFragmentDependency(Element container) {
        Element dep = container.addElement("dependency");
        dep.setText(CLIENT_WEB_FRAGMENT_MANAGER_MODULE_KEY);
    }

    protected Element addElement(Element container, String name, ClientWebFragmentFieldType type, String value) {
        return this.addElement(container, name, type, value, null);
    }

    protected Element addElement(Element container, String name, ClientWebFragmentFieldType type, String value, String i18nKey) {
        Element e = container.addElement(name);
        e.addAttribute("type", type.name());
        if (i18nKey != null) {
            e.addAttribute("i18n_key", i18nKey);
        }
        e.setText(value);
        return e;
    }

    protected void addDefaultFields(Element container, Element originalElement) {
        String moduleKey = originalElement.attributeValue("key");
        this.addStringElement(container, "pluginKey", this.plugin.getKey());
        this.addStringElement(container, "key", moduleKey);
        this.addStringElement(container, "moduleKey", moduleKey);
        this.addStringElement(container, "completeModuleKey", this.plugin.getKey() + ":" + moduleKey);
        this.addNumberElement(container, "weight", this.getWeight());
        this.copyElement("client-condition", "condition", originalElement, container, ClientWebFragmentFieldType.JS);
        this.copyElement("client-context-provider", "context-provider", originalElement, container, ClientWebFragmentFieldType.JS);
        this.copyParamElements(originalElement, container);
    }

    protected abstract void addFields(Element var1, Element var2);

    protected Element addJsElement(Element container, String name, String value) {
        return this.addElement(container, name, ClientWebFragmentFieldType.JS, value);
    }

    protected Element addNumberElement(Element container, String name, float value) {
        return this.addElement(container, name, ClientWebFragmentFieldType.NUMBER, String.valueOf(value));
    }

    private void addPlaceholderResource(Element container) {
        Element e = container.addElement("resource");
        e.addAttribute("type", "download");
        e.addAttribute("name", "descriptor.js");
        e.addAttribute("location", "/web-fragment-placeholder.config");
        Element source = e.addElement("param");
        source.addAttribute("name", "source");
        source.addAttribute("value", "webContextStatic");
        Element contentType = e.addElement("param");
        contentType.addAttribute("name", "contentType");
        contentType.addAttribute("value", "text/javascript");
    }

    protected Element addTextElement(Element container, String name, String value) {
        return this.addTextElement(container, name, value, null);
    }

    protected Element addTextElement(Element container, String name, String value, String i18nKey) {
        if (value != null) {
            return this.addElement(container, name, ClientWebFragmentFieldType.TEXT, value, i18nKey);
        }
        return null;
    }

    protected Element addStringElement(Element container, String name, String value) {
        if (value != null) {
            return this.addElement(container, name, ClientWebFragmentFieldType.STRING, value, null);
        }
        return null;
    }

    private Element addConfigTransformationElement(Element container, Element originalElement) {
        Element e = container.addElement("transformation");
        e.addAttribute("extension", "config");
        this.addFragmentTransformerElement(e, originalElement);
        this.addI18nTransformerElement(e);
        return container;
    }

    private Element addFragmentTransformerElement(Element container, Element originalElement) {
        Element t = container.addElement("transformer");
        t.addAttribute("key", this.getFragmentType().getTransformerKey());
        this.addDefaultFields(t, originalElement);
        this.addFields(t, originalElement);
        return t;
    }

    private Element addI18nTransformerElement(Element container) {
        Element t = container.addElement("transformer");
        t.addAttribute("key", "jsI18n");
        return t;
    }

    protected ClientWebFragmentFieldType getType(Element el, ClientWebFragmentFieldType defaultType) {
        return ClientWebFragmentFieldType.fromTypeAttribute(el.attributeValue("type"), defaultType);
    }

    private void copyElement(Element el, String tagName, Element destContainer, ClientWebFragmentFieldType defaultType) {
        ClientWebFragmentFieldType type = this.getType(el, defaultType);
        switch (type) {
            case JS: {
                this.addJsElement(destContainer, tagName, this.readJsElement(el));
                break;
            }
            case TEXT: {
                String defaultText = el.getText();
                String i18nKey = el.attributeValue("key");
                this.addTextElement(destContainer, tagName, defaultText, i18nKey);
                break;
            }
            case NUMBER: {
                this.addNumberElement(destContainer, tagName, Float.parseFloat(el.getTextTrim()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("AbstractClientWebFragmentModuleDescriptor cannot handle the type " + type.name());
            }
        }
    }

    protected void copyElement(String elementName, Element srcContainer, Element destContainer, ClientWebFragmentFieldType defaultType) {
        this.copyElement(elementName, null, srcContainer, destContainer, defaultType);
    }

    protected void copyElement(String srcName, String destName, Element srcContainer, Element destContainer, ClientWebFragmentFieldType defaultType) {
        Element source = srcContainer.element(srcName);
        if (source == null) {
            return;
        }
        this.copyElement(source, destName == null ? source.getName() : destName, destContainer, defaultType);
    }

    protected void copyParamElements(Element srcContainer, Element destContainer) {
        List sourceElements = srcContainer.elements("param");
        Element root = destContainer.addElement("params");
        root.addAttribute("type", ClientWebFragmentFieldType.OBJECT.name());
        for (Object o : sourceElements) {
            Element e = (Element)o;
            String value = e.attributeValue("value");
            if (value == null) {
                value = e.getText();
            }
            this.addElement(root, e.attributeValue("name"), this.getType(e, ClientWebFragmentFieldType.TEXT), value, null);
        }
    }

    @Override
    public void enabled() {
        super.enabled();
        this.clientWebInterfaceManager.refresh();
        if (this.contextProviderClass != null) {
            try {
                this.contextProvider = this.webFragmentHelper.loadContextProvider(this.contextProviderClass, this.getPlugin());
            }
            catch (ConditionLoadingException e) {
                throw new PluginParseException("Error parsing <context-provider>: ", (Throwable)e);
            }
        }
        this.condition = this.conditionElementParser.makeConditions(this.plugin, this.getOriginalElement(), 1);
    }

    public void disabled() {
        super.disabled();
        this.clientWebInterfaceManager.refresh();
        this.contextProvider = null;
    }

    @Override
    protected Element generateElement(Element originalElement) {
        Element generated = super.generateElement(originalElement);
        String weightStr = originalElement.attributeValue("weight");
        try {
            this.weight = weightStr != null ? Integer.parseInt(weightStr, 10) : 1000;
        }
        catch (NumberFormatException e) {
            throw new PluginParseException("weight must be an integer value. Was: " + weightStr);
        }
        Element contextProviderEl = this.getOriginalElement().element("context-provider");
        if (contextProviderEl != null) {
            this.contextProviderClass = contextProviderEl.attributeValue("class");
        }
        for (Object element : generated.elements("condition")) {
            ((Node)element).detach();
        }
        for (Object element : generated.elements("conditions")) {
            ((Node)element).detach();
        }
        this.addPlaceholderResource(generated);
        AbstractClientWebFragmentModuleDescriptor.addClientWebFragmentDependency(generated);
        this.addConfigTransformationElement(generated, originalElement);
        return generated;
    }

    public boolean canEncodeStateIntoUrl() {
        return true;
    }

    public boolean shouldDisplay(QueryParams ignored) {
        return true;
    }

    public boolean shouldDisplayImmediate() {
        return true;
    }

    @Override
    public ContextProvider getPageDataProvider() {
        if (this.contextProvider != null || this.condition != null) {
            return new WebFragmentPageDataProvider();
        }
        return null;
    }

    @Override
    public Set<String> getPageDataContexts() {
        return Sets.newHashSet((Object[])new String[]{this.getLocation()});
    }

    protected abstract ClientWebFragmentType getFragmentType();

    public abstract String getLocation();

    public int getWeight() {
        return this.weight;
    }

    protected String readJsElement(Element e) {
        if (e != null) {
            return e.getTextTrim();
        }
        return null;
    }

    private class WebFragmentPageDataProvider
    implements ContextProvider {
        private WebFragmentPageDataProvider() {
        }

        public void init(Map<String, String> params) throws PluginParseException {
        }

        public Map<String, Object> getContextMap(Map<String, Object> context) {
            HashMap webFragmentContext = Maps.newHashMap();
            boolean displayFragment = true;
            if (AbstractClientWebFragmentModuleDescriptor.this.condition != null) {
                displayFragment = AbstractClientWebFragmentModuleDescriptor.this.condition.shouldDisplay(context);
                webFragmentContext.put("serverCondition", displayFragment);
            }
            if (AbstractClientWebFragmentModuleDescriptor.this.contextProvider != null && displayFragment) {
                webFragmentContext.put("serverContext", AbstractClientWebFragmentModuleDescriptor.this.contextProvider.getContextMap(context));
            }
            return webFragmentContext;
        }
    }
}

