/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.stash.internal.plugin.PluginPathScanner;
import com.atlassian.stash.internal.plugin.PluginPathScannerFactory;
import com.atlassian.stash.internal.plugin.PreprocessedWebResourceModuleDescriptor;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@Component
public class WebResourceGenerationHelper {
    private static final Logger log = LoggerFactory.getLogger(WebResourceGenerationHelper.class);
    private static final Pattern IE_ONLY = Pattern.compile(".*-ie(\\d*)\\.(css|js)");
    private static final String SVG_FILE_EXTENSION = ".svg";
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();
    private static final Map<String, Collection<String>> RESOURCE_TRANSFORMS = ImmutableMap.builder().put((Object)"js", (Object)Lists.newArrayList((Object[])new String[]{"stashJsHelp", "stashJsI18n", "jsI18n", "development"})).put((Object)"soy", (Object)Lists.newArrayList((Object[])new String[]{"soyTransformer", "stashJsHelp", "stashJsI18n", "jsI18n", "development"})).put((Object)"less", (Object)Lists.newArrayList((Object[])new String[]{"less-transformer"})).build();
    private final PluginPathScannerFactory pluginPathScannerFactory;

    @Autowired
    public WebResourceGenerationHelper(PluginPathScannerFactory pluginPathScannerFactory) {
        this.pluginPathScannerFactory = pluginPathScannerFactory;
    }

    public void addDefaultTransforms(Element container) {
        for (Map.Entry<String, Collection<String>> entry : RESOURCE_TRANSFORMS.entrySet()) {
            this.addTransforms(container, entry.getKey(), (Iterable<String>)entry.getValue());
        }
    }

    private void addTransforms(Element container, String fileExtension, Iterable<String> transformKeys) {
        Element e = container.addElement("transformation");
        e.addAttribute("extension", fileExtension);
        for (String key : transformKeys) {
            Element t = e.addElement("transformer");
            t.addAttribute("key", key);
        }
    }

    private String changeFileExtension(String path, String oldExtension, String newExtension) {
        if (path.endsWith(oldExtension)) {
            return path.substring(0, path.length() - oldExtension.length()) + newExtension;
        }
        return path;
    }

    private String getNameFromLocation(String location, String directoryToScan) {
        String name = location.substring(directoryToScan.length());
        name = this.changeFileExtension(name, ".less", ".css");
        name = this.changeFileExtension(name, ".soy", ".soy.js");
        return name;
    }

    private Set<String> getPredefinedResources(Element resourceContainer) {
        HashSet predefinedResources = Sets.newHashSet();
        for (Object resourceObj : resourceContainer.elements("resource")) {
            String location;
            Element resource = (Element)resourceObj;
            if (!"download".equalsIgnoreCase(resource.attributeValue("type")) || !StringUtils.isNotBlank((String)(location = resource.attributeValue("location")))) continue;
            predefinedResources.add(location);
        }
        return predefinedResources;
    }

    private Set<String> getExcludedPatterns(Element directoryElement) {
        return Sets.union((Set)Sets.newHashSet((Object[])new String[]{"/**/*-min*.*", "/**/*.min*.*", "/**/*.less.css", "/**/*-less.css"}), this.getPatterns(directoryElement, "exclude"));
    }

    private Set<String> getIncludedPatterns(Element directoryElement) {
        return this.getPatterns(directoryElement, "include");
    }

    private Set<String> getPatterns(Element directoryElement, String attributeName) {
        HashSet excludes = Sets.newHashSet();
        for (Object excludesObj : directoryElement.elements(attributeName)) {
            String exclude = ((Element)excludesObj).getText();
            if (!StringUtils.isNotBlank((String)exclude)) continue;
            Collections.addAll(excludes, exclude.split(","));
        }
        return excludes;
    }

    public void addResourceElements(PreprocessedWebResourceModuleDescriptor moduleDescriptor) {
        Set<String> predefinedResources = this.getPredefinedResources(moduleDescriptor.getElement());
        List directories = moduleDescriptor.getOriginalElement().elements("directory");
        for (Element directory : directories) {
            this.addResourceElementsForDirectory(moduleDescriptor, directory, predefinedResources);
        }
    }

    private void addResourceElementsForDirectory(PreprocessedWebResourceModuleDescriptor moduleDescriptor, Element directory, Set<String> predefinedResources) {
        Set<String> excludedPatterns = this.getExcludedPatterns(directory);
        Set<String> includedPatterns = this.getIncludedPatterns(directory);
        String directoryToScan = this.normalizedDirectory(directory.attributeValue("location"));
        boolean isWebContextStatic = "webContextStatic".equalsIgnoreCase(directory.attributeValue("source"));
        PluginPathScanner scanner = this.pluginPathScannerFactory.forPlugin(moduleDescriptor.getPlugin(), isWebContextStatic);
        if (StringUtils.isNotBlank((String)directoryToScan)) {
            for (String location : scanner.getPaths(directoryToScan)) {
                if (predefinedResources.contains(location)) {
                    log.debug("Web resource '{}:{}' explicitly defined, skipping", (Object)moduleDescriptor.getCompleteKey(), (Object)location);
                    continue;
                }
                if (this.matchesPath(excludedPatterns, location) || !includedPatterns.isEmpty() && !this.matchesPath(includedPatterns, location)) continue;
                this.addResourceElement(moduleDescriptor.getElement(), directoryToScan, isWebContextStatic, location);
            }
        } else {
            log.info("<directory> element 'location' attribute not present for module '{}', skipping automatic resource generation", (Object)moduleDescriptor.getCompleteKey());
        }
    }

    private boolean matchesPath(Set<String> patterns, String location) {
        boolean matched = false;
        for (String pattern : patterns) {
            if (!PATH_MATCHER.match(pattern, location)) continue;
            matched = true;
            break;
        }
        return matched;
    }

    private void addResourceElement(Element resourceContainer, String directoryToScan, boolean webContextStatic, String location) {
        Element param;
        Matcher ieOnlyMatcher;
        String name = this.getNameFromLocation(location, directoryToScan);
        Element e = resourceContainer.addElement("resource");
        e.addAttribute("type", "download");
        e.addAttribute("name", name);
        e.addAttribute("location", location);
        if (webContextStatic) {
            Element param2 = e.addElement("param");
            param2.addAttribute("name", "source");
            param2.addAttribute("value", "webContextStatic");
        }
        if ((ieOnlyMatcher = IE_ONLY.matcher(name)).matches()) {
            param = e.addElement("param");
            param.addAttribute("name", "conditionalComment");
            param.addAttribute("value", StringUtils.isNotEmpty((String)ieOnlyMatcher.group(1)) ? "lte IE " + ieOnlyMatcher.group(1) : "IE");
        }
        if (name.endsWith(SVG_FILE_EXTENSION)) {
            param = e.addElement("param");
            param.addAttribute("name", "content-type");
            param.addAttribute("value", "image/svg+xml");
        }
    }

    private String normalizedDirectory(String location) {
        if (!Strings.isNullOrEmpty((String)location)) {
            location = location.endsWith("/") ? location : location + "/";
            location = location.startsWith("/") ? location : "/" + location;
        }
        return location;
    }
}

