/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.stash.content.SimplePath;
import com.atlassian.stash.internal.plugin.PluginPathScanner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiBundledPathScanner
implements PluginPathScanner {
    private static final Logger log = LoggerFactory.getLogger(OsgiBundledPathScanner.class);
    private final OsgiPlugin plugin;

    public OsgiBundledPathScanner(OsgiPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Iterable<String> getPaths(String directoryToScan) {
        return OsgiBundledPathScanner.scanForPaths(this.plugin.getBundle(), directoryToScan);
    }

    private static Iterable<String> scanForPaths(Bundle bundle, String startPath) {
        return OsgiBundledPathScanner.scanForPaths(bundle, startPath, (Predicate<String>)Predicates.alwaysTrue());
    }

    private static Iterable<String> scanForPaths(Bundle bundle, String startPath, Predicate<String> predicate) {
        HashSet<String> paths = new HashSet<String>();
        OsgiBundledPathScanner.scanPath(bundle, startPath, startPath, paths, predicate);
        if (paths.isEmpty()) {
            log.debug("No resources found at " + startPath + " in bundle " + bundle.getSymbolicName());
        }
        return paths;
    }

    private static void scanPath(Bundle bundle, String root, String prefix, Set<String> paths, Predicate<String> predicate) {
        Enumeration entryPaths = bundle.getEntryPaths(prefix);
        if (entryPaths == null) {
            log.warn("Cannot scan directory {} in bundle {} as it does not exist", (Object)prefix, (Object)bundle.getSymbolicName());
            return;
        }
        while (entryPaths.hasMoreElements()) {
            String fullPath = (String)entryPaths.nextElement();
            if (fullPath.endsWith("/")) {
                OsgiBundledPathScanner.scanPath(bundle, root, fullPath, paths, predicate);
                continue;
            }
            String path = fullPath.substring(root.length() - 1);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!predicate.apply((Object)path)) continue;
            paths.add(SimplePath.join((String)root, (String)path));
        }
    }
}

