/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.servlet.AbstractFileServerServlet;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.stash.internal.locale.LocaleUtils;
import com.atlassian.stash.util.Operation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpRequestHandler;

@Component(value="fileServerServlet")
public class FileServerServlet
extends AbstractFileServerServlet
implements HttpRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(FileServerServlet.class);
    private final List<DownloadStrategy> downloadStrategies;

    @Autowired
    public FileServerServlet(DownloadStrategy[] downloadStrategies) {
        Preconditions.checkArgument((((DownloadStrategy[])Preconditions.checkNotNull((Object)downloadStrategies, (Object)"downloadStrategies")).length > 0 ? 1 : 0) != 0, (Object)"At least one DownloadStrategy must be available");
        this.downloadStrategies = ImmutableList.copyOf((Object[])downloadStrategies);
    }

    public void handleRequest(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        Operation<Void, IOException> doGet = new Operation<Void, IOException>(){

            public Void perform() throws IOException {
                FileServerServlet.this.doGet(request, response);
                return null;
            }
        };
        String statichash = (String)request.getAttribute("_statichash");
        if (statichash == null) {
            doGet.perform();
        } else {
            LocaleUtils.withLocale(FileServerServlet.getLocaleFromPath(statichash), doGet);
        }
    }

    protected List<DownloadStrategy> getDownloadStrategies() {
        return this.downloadStrategies;
    }

    static Locale getLocaleFromPath(String path) {
        for (String s : path.split("/")) {
            if (s.length() != 2 && (s.length() <= 3 || s.charAt(2) != '_')) continue;
            try {
                return org.apache.commons.lang.LocaleUtils.toLocale((String)s);
            }
            catch (IllegalArgumentException e) {
                log.debug("Invalid locale {}: {}", (Object)s, (Object)e.getMessage());
            }
        }
        return null;
    }
}

