/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import java.io.File;

public class HomeDirectoryResolver {
    static final String HOME_DIR_ENV_VARIABLE = "STASH_HOME";

    public File resolve() {
        String home = System.getProperty("stash.home");
        if (home == null && (home = this.getEnv(HOME_DIR_ENV_VARIABLE)) != null) {
            System.setProperty("stash.home", home);
        }
        if (home == null) {
            throw new IllegalStateException("No home directory is defined using either the system property 'stash.home' or the environment variable 'STASH_HOME'");
        }
        if (home.startsWith("~")) {
            throw new IllegalStateException("The home directory [" + home + "] is invalid; tilde expansion is not " + "supported. Please use an absolute path referring to a specific home directory.");
        }
        return new File(home).getAbsoluteFile();
    }

    protected String getEnv(String environmentVariable) {
        return System.getenv(environmentVariable);
    }
}

