/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.stash.internal.event.InvokerTransformer;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBatchingInvokersTransformer
implements InvokerTransformer {
    private static final Logger log = LoggerFactory.getLogger(AsyncBatchingInvokersTransformer.class);
    private static final Predicate<ListenerInvoker> SUPPORTS_ASYNC = new Predicate<ListenerInvoker>(){

        public boolean apply(ListenerInvoker invoker) {
            return invoker.supportAsynchronousEvents();
        }
    };

    @Override
    @Nonnull
    public Iterable<ListenerInvoker> transformAll(@Nonnull Iterable<ListenerInvoker> invokers, @Nonnull Object event) {
        int invokerCount = Iterables.size(invokers);
        boolean isAsyncEvent = this.isAsynchronousEvent(event);
        if (isAsyncEvent && invokerCount >= 2) {
            Iterable syncInvokers = Iterables.filter(invokers, (Predicate)Predicates.not(SUPPORTS_ASYNC));
            Iterable asyncInvokers = Iterables.filter(invokers, SUPPORTS_ASYNC);
            int asyncInvokerCount = Iterables.size((Iterable)asyncInvokers);
            int syncInvokerCount = Iterables.size((Iterable)syncInvokers);
            double batchCount = AsyncBatchingInvokersTransformer.log2(asyncInvokerCount);
            int batchSize = (int)Math.ceil((double)asyncInvokerCount / batchCount);
            Chainable asyncInvokerBatches = Chainable.chain((Iterable)asyncInvokers).partition(batchSize).transform((Function)new Function<List<ListenerInvoker>, ListenerInvoker>(){

                public ListenerInvoker apply(List<ListenerInvoker> batch) {
                    return new AsyncInvokerBatch(batch);
                }
            });
            log.trace("@AsynchronousPreferred event {}: {} async invoker batches (from {} original async invokers) and {} sync invokers to dispatch to", new Object[]{event.getClass().getName(), Iterables.size((Iterable)asyncInvokerBatches), asyncInvokerCount, syncInvokerCount});
            return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)asyncInvokerBatches, (Iterable)syncInvokers));
        }
        log.trace("{} event {}: {} invokers to dispatch to", new Object[]{isAsyncEvent ? "@AsynchronousPreferred" : "Synchronous", event.getClass().getName(), invokerCount});
        return invokers;
    }

    private boolean isAsynchronousEvent(Object event) {
        return Preconditions.checkNotNull((Object)event).getClass().getAnnotation(AsynchronousPreferred.class) != null;
    }

    private static double log2(int size) {
        return Math.log(size) / Math.log(2.0);
    }

    private static class AsyncInvokerBatch
    implements ListenerInvoker {
        private final Iterable<ListenerInvoker> invokers;

        public AsyncInvokerBatch(Iterable<ListenerInvoker> invokers) {
            this.invokers = invokers;
        }

        public Set<Class<?>> getSupportedEventTypes() {
            throw new UnsupportedOperationException("Unsupported for batched ListenerInvokers");
        }

        public void invoke(Object event) {
            for (ListenerInvoker invoker : this.invokers) {
                try {
                    invoker.invoke(event);
                }
                catch (Exception e) {
                    log.error("There was an exception thrown trying to dispatch event '" + event + "' for the invoker '" + invoker + "'.", (Throwable)e);
                }
            }
        }

        public boolean supportAsynchronousEvents() {
            return true;
        }

        public String toString() {
            return "AsyncInvokerBatch{invokers=" + this.invokers + '}';
        }
    }
}

