/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.security.auth.trustedapps.filter.AuthenticationListener;
import com.atlassian.security.auth.trustedapps.filter.Authenticator;
import com.atlassian.stash.event.AuthenticationFailureEvent;
import com.atlassian.stash.event.AuthenticationSuccessEvent;
import com.atlassian.stash.user.UserService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrustedApplicationsAuthListener
implements AuthenticationListener {
    static final String AUTHENTICATION_METHOD = "trusted-apps";
    private final EventPublisher eventPublisher;
    private final UserService userService;

    @Autowired
    public TrustedApplicationsAuthListener(EventPublisher eventPublisher, UserService userService) {
        this.eventPublisher = eventPublisher;
        this.userService = userService;
    }

    public void authenticationSuccess(Authenticator.Result result, HttpServletRequest request, HttpServletResponse response) {
        this.userService.preauthenticate(result.getUser().getName());
        this.eventPublisher.publish((Object)new AuthenticationSuccessEvent((Object)this, result.getUser().getName(), AUTHENTICATION_METHOD));
    }

    public void authenticationFailure(Authenticator.Result result, HttpServletRequest request, HttpServletResponse response) {
        this.eventPublisher.publish((Object)new AuthenticationFailureEvent((Object)this, null, AUTHENTICATION_METHOD, null));
    }

    public void authenticationError(Authenticator.Result result, HttpServletRequest request, HttpServletResponse response) {
    }

    public void authenticationNotAttempted(HttpServletRequest request, HttpServletResponse response) {
    }
}

