/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.stash.repository.Version;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    private static final Logger log = LoggerFactory.getLogger(BuildInfo.class);
    public static final String BUILD_TIMESTAMP = "build.timestamp";
    public static final String BUILD_TIMESTAMP_FORMAT = "build.timestamp.format";
    public static final String BUILD_VERSION = "build.version";
    public static final String COMMIT_HASH = "commit.hash";
    public static final String COMMIT_TIMESTAMP = "commit.timestamp";
    private final String buildNumber;
    private final Date buildTimestamp;
    private final String buildVersion;
    private final String commitHash;
    private final Date commitTimestamp;

    public BuildInfo(Properties properties) {
        this.buildVersion = properties.getProperty(BUILD_VERSION);
        this.buildNumber = BuildInfo.calculateBuildNumber(this.buildVersion);
        this.commitHash = properties.getProperty(COMMIT_HASH);
        this.buildTimestamp = BuildInfo.parseBuildTimestamp(properties, BUILD_TIMESTAMP_FORMAT);
        this.commitTimestamp = BuildInfo.parseCommitTimestamp(properties, COMMIT_TIMESTAMP);
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public Date getBuildTimestamp() {
        return new Date(this.buildTimestamp.getTime());
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public String getDisplayCommitHash() {
        return StringUtils.substring((String)this.commitHash, (int)0, (int)7);
    }

    public Date getCommitTimestamp() {
        return this.commitTimestamp == null ? null : new Date(this.commitTimestamp.getTime());
    }

    private static String calculateBuildNumber(String buildVersion) {
        List version = new Version(buildVersion).getVersion();
        long major = ((Integer)version.get(0)).intValue();
        long minor = ((Integer)version.get(1)).intValue();
        long patch = ((Integer)version.get(2)).intValue();
        long full = (major * 1000L + minor) * 1000L + patch;
        return String.valueOf(full);
    }

    private static Date parseBuildTimestamp(Properties buildProperties, String property) {
        try {
            return new SimpleDateFormat(buildProperties.getProperty(property)).parse(buildProperties.getProperty(BUILD_TIMESTAMP));
        }
        catch (Exception e) {
            log.warn("Failed to parse the build timestamp, using current time instead", (Throwable)e);
            return new Date();
        }
    }

    private static Date parseCommitTimestamp(Properties buildProperties, String property) {
        try {
            return new Date(Long.parseLong(buildProperties.getProperty(property)));
        }
        catch (Exception e) {
            return null;
        }
    }
}

