/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.process;

import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.process.ExternalProcessConfigurer;
import com.atlassian.utils.process.DefaultExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcessImpl;
import com.atlassian.utils.process.ExternalProcessSettings;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ConfigurableExternalProcessFactory
extends DefaultExternalProcessFactory {
    private final ApplicationSettings applicationSettings;
    private List<ExternalProcessConfigurer> configurers;
    private long executionTimeout;
    private long idleTimeout;

    public ConfigurableExternalProcessFactory(ExecutorService executorService, ApplicationSettings applicationSettings) {
        super(executorService);
        this.applicationSettings = applicationSettings;
        this.configurers = Collections.emptyList();
    }

    public ExternalProcess create(ExternalProcessSettings settings) {
        settings.setSuppressSpecialWindowsBehaviour(true);
        if (settings.getWorkingDirectory() == null) {
            settings.setWorkingDirectory(this.applicationSettings.getTempDir());
        }
        if (!settings.hasExecutionTimeout()) {
            settings.setExecutionTimeout(this.executionTimeout);
        }
        if (!settings.hasIdleTimeout()) {
            settings.setIdleTimeout(this.idleTimeout);
        }
        return super.create(settings);
    }

    @PostConstruct
    public void initialise() {
        ExternalProcessBuilder.setExternalProcessFactory((ExternalProcessFactory)this);
    }

    @Value(value="${process.timeout.execution}")
    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = TimeUnit.SECONDS.toMillis(executionTimeout);
    }

    @Value(value="${process.timeout.idle}")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = TimeUnit.SECONDS.toMillis(idleTimeout);
    }

    @Autowired(required=false)
    public void setConfigurers(List<ExternalProcessConfigurer> configurers) {
        this.configurers = ImmutableList.copyOf(configurers);
    }

    @PreDestroy
    public void shutdown() {
        super.shutdown();
    }

    protected void configureProcess(ExternalProcessImpl process, ExternalProcessSettings settings) {
        for (ExternalProcessConfigurer configurer : this.configurers) {
            configurer.configure(process, settings);
        }
        super.configureProcess(process, settings);
    }
}

