/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.home.HomeLockDeniedException;
import com.atlassian.stash.internal.home.HomeLockFailedException;
import com.atlassian.utils.process.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeLockAcquirer {
    private static final Logger log = LoggerFactory.getLogger(HomeLockAcquirer.class);
    private final I18nService i18nService;
    private final ApplicationSettings settings;
    private File lockFile;
    private FileOutputStream lockStream;

    public HomeLockAcquirer(ApplicationSettings settings, I18nService i18nService) {
        this.i18nService = i18nService;
        this.settings = settings;
    }

    public void lock() {
        if (this.lockStream != null) {
            throw new IllegalStateException("The lock is already held by this instance and cannot be reacquired");
        }
        File home = this.settings.getHomeDir();
        File file = new File(home, ".lock");
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                FileLock lock = stream.getChannel().tryLock();
                if (lock == null) {
                    log.error("Home directory {} has already been locked by another instance", (Object)home);
                    this.onLockDenied(home, file);
                }
                this.lockFile = file;
                this.lockStream = stream;
                String whoAmI = ManagementFactory.getRuntimeMXBean().getName();
                log.info("Successfully acquired lock on home directory {} for {}", (Object)home, (Object)whoAmI);
                try {
                    stream.write(whoAmI.getBytes());
                    stream.write(10);
                    stream.flush();
                }
                catch (IOException e) {
                    log.warn("Failed to write process information into the lock file", (Throwable)e);
                }
            }
            catch (OverlappingFileLockException e) {
                log.error("The current JVM holds an overlapping lock on home directory {}. Are there two {} instances deployed in the same application server?", (Object)home, (Object)ApplicationConstants.PRODUCT_NAME);
                this.onLockFailed(home, file, e);
            }
        }
        catch (IOException e) {
            log.error("Lock file " + file.getName() + " cannot be created in home directory " + home + ". Does " + System.getProperty("user.name") + " have write permission on that directory?", (Throwable)e);
            this.onLockFailed(home, file, e);
        }
    }

    public void unlock() {
        if (this.lockStream == null) {
            return;
        }
        log.info("Releasing lock on {}", (Object)this.settings.getHomeDir());
        IOUtils.closeQuietly((Closeable)this.lockStream);
        if (!this.lockFile.delete()) {
            this.lockFile.deleteOnExit();
            log.error("Failed to delete lock file {}; it may have to be deleted manually before {} can be started again", (Object)this.lockFile, (Object)ApplicationConstants.PRODUCT_NAME);
        }
        this.lockFile = null;
        this.lockStream = null;
    }

    private void onLockDenied(File home, File lock) {
        KeyedMessage message = this.i18nService.getKeyedText("stash.home.locked", "The {0} home directory ''{1}'' is already locked by another running instance of {0}.\n\nPlease stop the other instance of {0} and restart this instance.\n\nIf you are absolutely certain that no other instance of {0} is running, please remove the lock file ''{2}'' and restart this instance.", new Object[]{ApplicationConstants.PRODUCT_NAME, home.getAbsolutePath(), lock.getAbsolutePath()});
        throw new HomeLockDeniedException(message);
    }

    private void onLockFailed(File home, File lock, Exception e) {
        KeyedMessage message = this.i18nService.getKeyedText("stash.home.lock.failed", "Unable to create and acquire lock file ''{2}'' for {0} home directory ''{1}''.\n\nPlease ensure that the user running {0} has permission to write to this directory.\n\nIf this is already the case, please check the logs for more information.", new Object[]{ApplicationConstants.PRODUCT_NAME, home.getAbsolutePath(), lock.getName()});
        throw new HomeLockFailedException(message, e);
    }
}

