/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.internal.EventThreadFactory;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="eventExecutorFactory")
public class StateTransferringEventExecutorFactory
implements EventExecutorFactory {
    private static final Logger log = LoggerFactory.getLogger(StateTransferringEventExecutorFactory.class);
    private final EventThreadPoolConfiguration configuration;
    private final EventThreadFactory eventThreadFactory;
    private ExecutorService executorService;
    private final int maxQueueSize;
    private final ThreadLocalDelegateExecutorFactory threadLocalExecutorFactory;

    @Autowired
    public StateTransferringEventExecutorFactory(ThreadLocalDelegateExecutorFactory threadLocalExecutorFactory, EventThreadPoolConfiguration configuration, @Value(value="${event.dispatcher.queue.size}") int maxQueueSize) {
        this.configuration = configuration;
        this.eventThreadFactory = new EventThreadFactory();
        this.maxQueueSize = maxQueueSize;
        this.threadLocalExecutorFactory = threadLocalExecutorFactory;
    }

    public synchronized ExecutorService getExecutor() {
        if (this.executorService == null) {
            this.executorService = this.threadLocalExecutorFactory.createExecutorService((ExecutorService)new ThreadPoolExecutor(this.configuration.getCorePoolSize(), this.configuration.getMaximumPoolSize(), this.configuration.getKeepAliveTime(), this.configuration.getTimeUnit(), this.getQueue(), (ThreadFactory)this.eventThreadFactory));
        }
        return this.executorService;
    }

    @PreDestroy
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.debug("Event dispatcher executor service has shutdown gracefully");
                } else {
                    log.warn("Event dispatcher executor service did not shutdown within the timeout; forcing shutdown");
                    this.executorService.shutdownNow();
                    if (this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        log.debug("Event dispatcher executor service has been forced to shutdown");
                    } else {
                        log.warn("Event dispatcher executor service did not shutdown; it will be abandoned");
                    }
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for the event dispatcher executor service to shutdown; some worker threads may still be running");
                Thread.currentThread().interrupt();
            }
        }
    }

    protected BlockingQueue<Runnable> getQueue() {
        return new LinkedBlockingDeque<Runnable>(this.maxQueueSize);
    }
}

