/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.applinks.spi;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.applinks.api.application.stash.StashProjectEntityType;
import com.atlassian.applinks.host.spi.AbstractInternalHostApplication;
import com.atlassian.applinks.host.spi.DefaultEntityReference;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PagedIterable;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(interfaces={InternalHostApplication.class, HostApplication.class})
@Component(value="hostApplication")
public class StashHostApplication
extends AbstractInternalHostApplication {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final PermissionService permissionService;
    private final ProjectService projectService;
    private final SecurityService securityService;
    private final TypeAccessor typeAccessor;
    private volatile ApplicationId applicationId;

    @Autowired
    public StashHostApplication(PluginAccessor pluginAccessor, ApplicationPropertiesService applicationPropertiesService, ProjectService projectService, PermissionService permissionService, SecurityService securityService, TypeAccessor typeAccessor) {
        super(pluginAccessor);
        this.applicationPropertiesService = applicationPropertiesService;
        this.permissionService = permissionService;
        this.projectService = projectService;
        this.securityService = securityService;
        this.typeAccessor = typeAccessor;
    }

    public boolean canManageEntityLinksFor(EntityReference entityReference) {
        try {
            if (entityReference.getType() instanceof StashProjectEntityType) {
                Project project = this.findProject(entityReference.getKey());
                return project != null && this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN);
            }
        }
        catch (AuthorisationException authorisationException) {
            // empty catch block
        }
        return false;
    }

    public boolean doesEntityExist(String key, Class<? extends EntityType> type) {
        try {
            return this.findEntity(key, type) != null;
        }
        catch (AuthorisationException e) {
            return false;
        }
    }

    public boolean doesEntityExistNoPermissionCheck(final String key, final Class<? extends EntityType> type) {
        return (Boolean)this.securityService.doWithPermission("Promoting privilege for UAL", Permission.PROJECT_VIEW, (Operation)new UncheckedOperation<Boolean>(){

            public Boolean perform() throws RuntimeException {
                return StashHostApplication.this.doesEntityExist(key, type);
            }
        });
    }

    public URI getBaseUrl() {
        return this.applicationPropertiesService.getBaseUrl();
    }

    public URI getDocumentationBaseUrl() {
        return URI.create("http://confluence.atlassian.com/display/APPLINKS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationId getId() {
        if (this.applicationId == null) {
            StashHostApplication stashHostApplication = this;
            synchronized (stashHostApplication) {
                if (this.applicationId == null) {
                    byte[] sidBytes = this.applicationPropertiesService.getServerId().getBytes();
                    this.applicationId = new ApplicationId(UUID.nameUUIDFromBytes(sidBytes).toString());
                }
            }
        }
        return this.applicationId;
    }

    public Iterable<EntityReference> getLocalEntities() {
        return new PagedIterable((PageProvider)new PageProvider<EntityReference>(){

            public Page<EntityReference> get(PageRequest request) {
                return StashHostApplication.this.projectService.findAll(request).transform((Function)new Function<Project, EntityReference>(){

                    public EntityReference apply(Project project) {
                        return StashHostApplication.this.createProjectEntityReference(project);
                    }
                });
            }
        }, 100);
    }

    public String getName() {
        return this.applicationPropertiesService.getDisplayName();
    }

    public ApplicationType getType() {
        return this.typeAccessor.getApplicationType(StashApplicationType.class);
    }

    public boolean hasPublicSignup() {
        return this.applicationPropertiesService.isAllowPublicSignUp();
    }

    public EntityReference toEntityReference(Object domainObject) {
        if (domainObject instanceof Project) {
            Project project = (Project)domainObject;
            return this.createProjectEntityReference(project);
        }
        return null;
    }

    public EntityReference toEntityReference(String key, Class<? extends EntityType> type) {
        return this.findEntity(key, type);
    }

    private EntityReference createProjectEntityReference(Project project) {
        return new DefaultEntityReference(project.getKey(), project.getName(), (EntityType)Preconditions.checkNotNull((Object)this.typeAccessor.getEntityType(StashProjectEntityType.class), (Object)(StashProjectEntityType.class.getSimpleName() + " not installed!")));
    }

    private EntityReference findEntity(String key, Class<? extends EntityType> type) {
        if (StashProjectEntityType.class.isAssignableFrom(type)) {
            Project project = this.findProject(key);
            return project != null ? this.createProjectEntityReference(project) : null;
        }
        return null;
    }

    private Project findProject(String entityReferenceKey) {
        return this.projectService.getByKey(entityReferenceKey);
    }
}

