/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.stash.internal.annotation.Throttled;
import com.atlassian.stash.throttle.ThrottleService;
import com.atlassian.stash.throttle.Ticket;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class ThrottledAspect {
    private final ThrottleService throttleService;

    @Autowired
    public ThrottledAspect(ThrottleService throttleService) {
        this.throttleService = throttleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object throttle(ProceedingJoinPoint invocation, Throttled annotation) throws Throwable {
        if (annotation == null) {
            annotation = this.getAnnotationOnTargetMethod(invocation);
        }
        Ticket ticket = this.throttleService.acquireTicket(annotation.value());
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            ticket.release();
        }
    }

    protected Throttled getAnnotationOnTargetMethod(ProceedingJoinPoint invocation) {
        MethodSignature signature = (MethodSignature)invocation.getSignature();
        Class targetClass = AopUtils.getTargetClass((Object)invocation.getTarget());
        Method targetMethod = ClassUtils.getMostSpecificMethod((Method)signature.getMethod(), (Class)targetClass);
        return (Throttled)AnnotationUtils.findAnnotation((Method)targetMethod, Throttled.class);
    }
}

