/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.ao;

import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
@AvailableToPlugins(value=TransactionSynchronisationManager.class)
public class SpringTransactionSynchronisationManager
implements TransactionSynchronisationManager {
    public boolean runOnRollBack(Runnable callback) {
        return this.maybeRegisterSynchronization(callback, 1);
    }

    public boolean runOnSuccessfulCommit(Runnable callback) {
        return this.maybeRegisterSynchronization(callback, 0);
    }

    private boolean maybeRegisterSynchronization(Runnable callback, int status) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new RunnableTransactionSynchronization(callback, status));
            return true;
        }
        return false;
    }

    private static class RunnableTransactionSynchronization
    extends TransactionSynchronizationAdapter {
        private final Runnable runnable;
        private final int status;

        private RunnableTransactionSynchronization(Runnable runnable, int status) {
            this.runnable = runnable;
            this.status = status;
        }

        public void afterCompletion(int status) {
            if (this.status == status) {
                this.runnable.run();
            }
        }
    }
}

