/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleUtil {
    private static final Logger log = LoggerFactory.getLogger(BundleUtil.class);

    public static Bundle findBundleForPlugin(OsgiContainerManager osgiContainerManager, String pluginKey) {
        for (Bundle bundle : osgiContainerManager.getBundles()) {
            String maybePluginKey = (String)bundle.getHeaders().get("Atlassian-Plugin-Key");
            if (!pluginKey.equals(maybePluginKey)) continue;
            return bundle;
        }
        return null;
    }

    public static List<String> getPublicBundlePathsRecursive(Bundle bundle, String startPath) {
        Validate.notNull((Object)bundle);
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : BundleUtil.getDirContents(bundle, startPath)) {
            if (paths.contains(path) || path.startsWith("META-INF")) continue;
            if (path.endsWith("/")) {
                paths.add(path);
                paths.addAll(BundleUtil.getPublicBundlePathsRecursive(bundle, path));
                continue;
            }
            paths.add(path);
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntryToString(String path, Bundle bundle) throws IOException {
        String string;
        URL url = bundle.getEntry(path);
        InputStream in = null;
        try {
            StringWriter writer = new StringWriter();
            in = url.openStream();
            IOUtils.copy((InputStream)in, (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    private static Iterable<String> getDirContents(Bundle bundle, String startPath) {
        ArrayList<String> dirs = new ArrayList<String>();
        ArrayList<String> files = new ArrayList<String>();
        Enumeration e = bundle.getEntryPaths(startPath);
        while (e != null && e.hasMoreElements()) {
            String path = (String)e.nextElement();
            if (path.endsWith("/") && !dirs.contains(path)) {
                dirs.add(path);
                continue;
            }
            files.add(path);
        }
        Collections.sort(dirs);
        Collections.sort(files);
        ArrayList<String> contents = new ArrayList<String>(dirs);
        contents.addAll(files);
        return contents;
    }

    public static Iterable<String> scanForPaths(Bundle bundle, String startPath) {
        return BundleUtil.scanForPaths(bundle, startPath, (Predicate<String>)Predicates.alwaysTrue());
    }

    public static Iterable<String> scanForPaths(Bundle bundle, String startPath, Predicate<String> predicate) {
        HashSet<String> paths = new HashSet<String>();
        BundleUtil.scanPath(bundle, startPath, startPath, paths, predicate);
        if (paths.isEmpty()) {
            log.debug("No resources found at " + startPath + " in bundle " + bundle.getSymbolicName());
        }
        return paths;
    }

    private static void scanPath(Bundle bundle, String root, String prefix, Set<String> paths, Predicate<String> predicate) {
        Enumeration entryPaths = bundle.getEntryPaths(prefix);
        while (entryPaths != null && entryPaths.hasMoreElements()) {
            String fullPath = (String)entryPaths.nextElement();
            if (fullPath.endsWith("/")) {
                BundleUtil.scanPath(bundle, root, fullPath, paths, predicate);
                continue;
            }
            String path = fullPath.substring(root.length() - 1);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!predicate.apply((Object)path)) continue;
            paths.add(path);
        }
    }
}

