/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.ApplicationSettings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.ClassPathResource;

public class PluginConfigurationFactoryBean
extends AbstractFactoryBean<PluginsConfiguration> {
    public static final String KEY_ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    public static final String KEY_STASH_PLUGINS_LIST = "stash.plugins.list";
    private static final Logger LOG = LoggerFactory.getLogger(PluginConfigurationFactoryBean.class);
    private final String bundledPlugins;
    private final File bundledPluginsDirectory;
    private final HostComponentProvider hostComponentProvider;
    private final ModuleDescriptorFactory moduleDescriptorFactory;
    private final File osgiCacheDirectory;
    private final PackageScannerConfiguration packageScannerConfiguration;
    private final File pluginDirectory;
    private final PluginPersistentStateStore pluginPersistentStateStore;

    public PluginConfigurationFactoryBean(ApplicationSettings settings, HostComponentProvider hostComponentProvider, ModuleDescriptorFactory moduleDescriptorFactory, PackageScannerConfiguration packageScannerConfiguration, PluginPersistentStateStore pluginPersistentStateStore, String bundledPlugins) {
        this.bundledPlugins = bundledPlugins.startsWith("/") ? bundledPlugins : "/" + bundledPlugins;
        this.hostComponentProvider = hostComponentProvider;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.packageScannerConfiguration = packageScannerConfiguration;
        this.pluginPersistentStateStore = pluginPersistentStateStore;
        this.bundledPluginsDirectory = settings.getBundledPluginsDir();
        this.osgiCacheDirectory = settings.getOsgiCacheDir();
        this.pluginDirectory = settings.getInstalledPluginsDir();
    }

    public Class<?> getObjectType() {
        return PluginsConfiguration.class;
    }

    protected PluginsConfiguration createInstance() throws Exception {
        URL bundledPluginsUrl = PluginConfigurationFactoryBean.getBundledPluginsUrl(this.bundledPlugins);
        return new PluginsConfigurationBuilder().useLegacyDynamicPluginDeployer(true).bundledPluginUrl(bundledPluginsUrl).bundledPluginCacheDirectory(this.makeSureDirectoryExists(this.bundledPluginsDirectory)).pluginDirectory(this.makeSureDirectoryExists(this.pluginDirectory)).moduleDescriptorFactory(this.moduleDescriptorFactory).packageScannerConfiguration(this.packageScannerConfiguration).hostComponentProvider(this.hostComponentProvider).osgiPersistentCache(this.makeSureDirectoryExists(this.osgiCacheDirectory)).pluginStateStore(this.pluginPersistentStateStore).applicationKey(ApplicationConstants.APPLICATION_KEY).build();
    }

    private File makeSureDirectoryExists(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Could not create directory [" + dir + "]");
        }
        return dir;
    }

    private static URL getBundledPluginsUrl(String bundledPlugins) throws IOException {
        String list;
        if (Boolean.getBoolean(KEY_ATLASSIAN_DEV_MODE) && StringUtils.isNotBlank((String)(list = System.getProperty(KEY_STASH_PLUGINS_LIST)))) {
            try {
                return URI.create(list).toURL();
            }
            catch (MalformedURLException e) {
                LOG.warn("stash.plugins.list does not define a valid URL [" + list + "]", (Throwable)e);
            }
        }
        return new ClassPathResource(bundledPlugins).getURL();
    }
}

