/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.stash.internal.plugin.StashConditionFactory;
import com.atlassian.stash.ui.FormFragment;
import com.atlassian.util.concurrent.NotNull;
import javax.annotation.Nullable;
import org.dom4j.Element;

public class FormFragmentModuleDescriptor
extends AbstractModuleDescriptor<FormFragment> {
    public static final String XML_ELEMENT_NAME = "form-fragment";
    private final ConditionElementParser conditionElementParser;
    private String location = null;
    private Element element = null;
    private Condition condition = null;

    public FormFragmentModuleDescriptor(ModuleFactory moduleFactory, StashConditionFactory stashConditionFactory) {
        super(moduleFactory);
        this.conditionElementParser = new ConditionElementParser((ConditionElementParser.ConditionFactory)stashConditionFactory);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.location = element.attribute("location").getValue();
        this.element = element;
    }

    public void enabled() {
        super.enabled();
        this.condition = this.conditionElementParser.makeConditions(this.plugin, this.element, 1);
    }

    public void disabled() {
        this.condition = null;
        super.disabled();
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@class").withError("The class is required")});
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@location").withError("The location is required")});
    }

    public FormFragment getModule() {
        return (FormFragment)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    @Nullable
    public Condition getCondition() {
        return this.condition;
    }

    @NotNull
    public String getLocation() {
        return this.location;
    }
}

