/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RequestContextConverter
extends ClassicConverter
implements ContextAware,
LifeCycle {
    private final List<MDCConverter> converters = ImmutableList.builder().add((Object)RequestContextConverter.converterFor("a-username")).add((Object)RequestContextConverter.converterFor("a-request-id")).add((Object)RequestContextConverter.converterFor("a-session-id")).add((Object)RequestContextConverter.converterFor("a-remote-address")).add((Object)RequestContextConverter.converterFor("a-request-url")).build();

    public String convert(ILoggingEvent event) {
        StringBuilder builder = new StringBuilder();
        for (MDCConverter converter : this.converters) {
            String converted = converter.convert(event);
            if (!StringUtils.isNotEmpty((String)converted)) continue;
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(converted);
        }
        return builder.toString();
    }

    public void setContext(Context context) {
        super.setContext(context);
        for (MDCConverter converter : this.converters) {
            converter.setContext(context);
        }
    }

    public void start() {
        super.start();
        for (MDCConverter converter : this.converters) {
            converter.start();
        }
    }

    public void stop() {
        super.stop();
        for (MDCConverter converter : this.converters) {
            converter.stop();
        }
    }

    private static MDCConverter converterFor(String key) {
        MDCConverter converter = new MDCConverter();
        converter.setOptionList(Arrays.asList(key));
        return converter;
    }
}

