/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.util.profiling.UtilTimerStack;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ProfilingAspect {
    @Pointcut(value="@within(org.springframework.stereotype.Repository)")
    public void daoMethod() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Service)")
    public void serviceMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="daoMethod() || serviceMethod()")
    public Object profileMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        if (UtilTimerStack.isActive()) {
            String method = joinPoint.getSignature().toString();
            try {
                UtilTimerStack.push((String)method);
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                UtilTimerStack.pop((String)method);
            }
        }
        return joinPoint.proceed();
    }
}

