/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.ao;

import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDataSourceProvider.class);
    private static final Map<String, DatabaseType> jdbcTypeMap = ImmutableMap.builder().put((Object)"jdbc:hsqldb:", (Object)DatabaseType.HSQL).put((Object)"jdbc:mysql:", (Object)DatabaseType.MYSQL).put((Object)"jdbc:oracle:", (Object)DatabaseType.ORACLE).put((Object)"jdbc:postgresql:", (Object)DatabaseType.POSTGRESQL).put((Object)"jdbc:jtds:sqlserver:", (Object)DatabaseType.MS_SQL).put((Object)"jdbc:sqlserver:", (Object)DatabaseType.MS_SQL).build();
    private final DataSource dataSource;
    private final String jdbcURL;

    public ApplicationDataSourceProvider(DataSource dataSource, String jdbcURL) {
        this.dataSource = dataSource;
        this.jdbcURL = jdbcURL;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DatabaseType getDatabaseType() {
        if (this.jdbcURL != null) {
            for (Map.Entry<String, DatabaseType> entry : jdbcTypeMap.entrySet()) {
                if (!this.jdbcURL.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        LOG.warn("Could not determine database type for " + this.jdbcURL);
        return DatabaseType.UNKNOWN;
    }

    public String getSchema() {
        return null;
    }
}

