/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.setting.InternalSharedLob;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;

@Cacheable
@Entity
@Table(name="sta_repo_hook", indexes={@Index(name="idx_sta_repo_hook_hook_key", columnList="hook_key"), @Index(name="idx_sta_repo_hook_lob_id", columnList="lob_id"), @Index(name="idx_sta_repo_hook_repo_id", columnList="repository_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_repo_hook_repo_hook_key", columnNames={"repository_id", "hook_key"})})
@TableGenerator(allocationSize=20, pkColumnValue="sta_repo_hook", name="entityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalRepositoryHook
extends InternalAbstractEntity {
    public static final String TABLE = "sta_repo_hook";
    @Column(name="is_enabled", nullable=false)
    private final boolean enabled;
    @Column(name="hook_key", nullable=false, updatable=false)
    @RequiredString(size=255)
    private final String hookKey;
    @JoinColumn(name="repository_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_repo_hook_repo"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalRepository repository;
    @JoinColumn(name="lob_id", foreignKey=@ForeignKey(name="fk_sta_repo_hook_lob"))
    @OneToOne(cascade={CascadeType.MERGE}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    private final InternalSharedLob settings;

    protected InternalRepositoryHook() {
        this.enabled = false;
        this.hookKey = null;
        this.repository = null;
        this.settings = null;
    }

    private InternalRepositoryHook(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.hookKey = builder.hookKey;
        this.repository = builder.repository;
        this.settings = builder.settings;
    }

    @Nonnull
    public String getHookKey() {
        return this.hookKey;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nullable
    public InternalSharedLob getSettings() {
        return this.settings;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasSettings() {
        return this.settings != null;
    }

    public static class Builder
    extends InternalAbstractEntity.AbstractEntityBuilder<Builder, InternalRepositoryHook> {
        private boolean enabled;
        private String hookKey;
        private InternalRepository repository;
        private InternalSharedLob settings;

        public Builder() {
        }

        public Builder(@Nonnull InternalRepositoryHook hook) {
            super(hook);
            this.enabled = ((InternalRepositoryHook)Preconditions.checkNotNull((Object)hook, (Object)"hook")).isEnabled();
            this.hookKey = hook.getHookKey();
            this.repository = hook.getRepository();
            this.settings = hook.getSettings();
        }

        @Override
        @Nonnull
        public InternalRepositoryHook build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.hookKey), (Object)"The hook key is required");
            Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"The hook repository is required");
            return new InternalRepositoryHook(this);
        }

        @Nonnull
        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public Builder hookKey(@Nonnull String value) {
            this.hookKey = Builder.checkNotBlank((String)value, (String)"hookKey");
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull InternalRepository value) {
            this.repository = (InternalRepository)Preconditions.checkNotNull((Object)value, (Object)"repository");
            return this;
        }

        @Nonnull
        public Builder settings(@Nullable InternalSharedLob value) {
            this.settings = value;
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

