/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.property;

import com.atlassian.stash.content.AttributeSupport;
import com.atlassian.stash.internal.content.AbstractAttributeSupport;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.property.PropertySupport;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@MappedSuperclass
public abstract class AbstractPropertySupport
extends AbstractAttributeSupport
implements PropertySupport {
    @Transient
    private transient PropertyMap properties;

    protected AbstractPropertySupport() {
    }

    protected AbstractPropertySupport(@Nonnull PropertyBuilderSupport<?> builder) {
        super(builder);
        this.properties = ((PropertyBuilderSupport)builder).properties.build();
    }

    @Nonnull
    public PropertyMap getProperties() {
        if (this.properties == null) {
            this.properties = PropertyMap.EMPTY;
        }
        return this.properties;
    }

    public void setProperties(@Nonnull PropertyMap properties) {
        Preconditions.checkNotNull((Object)properties, (Object)"properties");
        if (this.hasProperties()) {
            throw new IllegalStateException("Properties have already been set; you cannot override once set.");
        }
        this.properties = properties;
    }

    protected boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    protected static abstract class PropertyBuilderSupport<B extends PropertyBuilderSupport<B>>
    extends AbstractAttributeSupport.AttributeBuilderSupport<B> {
        private final PropertyMap.Builder properties = new PropertyMap.Builder();

        protected PropertyBuilderSupport() {
        }

        protected PropertyBuilderSupport(@Nonnull PropertySupport propertyHolder) {
            super((AttributeSupport)propertyHolder);
            this.properties.properties((Map)propertyHolder.getProperties());
        }

        @Nonnull
        public B property(@Nonnull String key, @Nonnull Object value) {
            this.properties.property(key, value);
            return (B)((Object)this.self());
        }

        @Nonnull
        public B properties(@Nonnull Map<String, Object> other) {
            this.properties.properties(other);
            return (B)((Object)this.self());
        }

        @Override
        @Nonnull
        protected abstract B self();
    }
}

