/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.CommentOperations;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.property.AbstractPropertySupport;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.property.PropertySupport;
import com.atlassian.stash.task.Task;
import com.atlassian.stash.task.TaskAnchorVisitor;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="sta_comment", indexes={@Index(name="idx_sta_comment_author", columnList="author_id"), @Index(name="idx_sta_comment_parent", columnList="parent_id"), @Index(name="idx_sta_comment_root", columnList="root_id")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalComment
extends AbstractPropertySupport
implements Comment,
Initializable {
    public static final String ID_GEN = "commentIdGenerator";
    public static final String TABLE = "sta_comment";
    @JoinColumn(name="author_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_comment_author"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalStashUser author;
    @OneToMany(mappedBy="parent", targetEntity=InternalComment.class)
    @OrderBy(value="createdDate")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    private final List<Comment> comments = new ArrayList<Comment>();
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="commentIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_comment", name="commentIdGenerator", table="id_sequence")
    private final Long id;
    @JoinColumn(name="parent_id", foreignKey=@ForeignKey(name="fk_sta_comment_parent"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalComment parent;
    @JoinColumn(name="root_id", foreignKey=@ForeignKey(name="fk_sta_comment_root"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalComment root;
    @Column(name="comment_text", nullable=false)
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String text;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;
    @Transient
    private CommentOperations permittedOperations;
    @Transient
    private List<Task> tasks;

    protected InternalComment() {
        this.createdDate = null;
        this.id = null;
        this.parent = null;
        this.root = null;
        this.text = null;
        this.updatedDate = null;
        this.version = 0;
    }

    private InternalComment(Builder builder) {
        super(builder);
        this.author = builder.author;
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.parent = InternalComment.notSelf(this.id, builder.parent);
        this.root = InternalComment.notSelf(this.id, builder.root);
        this.text = builder.text;
        this.updatedDate = builder.updatedDate;
        this.version = builder.version;
    }

    public <T> T accept(@Nonnull TaskAnchorVisitor<T> visitor) {
        return (T)visitor.visit((Comment)this);
    }

    @Nonnull
    public InternalStashUser getAuthor() {
        return this.author;
    }

    @Nonnull
    public List<Comment> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Long getId() {
        return this.id;
    }

    public InternalComment getParent() {
        return this.parent;
    }

    @Nonnull
    public InternalComment getRoot() {
        return this.root == null ? this : this.root;
    }

    @Nonnull
    public List<Task> getTasks() {
        return this.tasks == null ? Collections.emptyList() : this.tasks;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public int getVersion() {
        return this.version;
    }

    public CommentOperations getPermittedOperations() {
        return this.permittedOperations;
    }

    @Override
    public void initialize() {
        this.author = HibernateUtils.initialize(this.getAuthor());
        Hibernate.initialize(this.getComments());
        for (Comment comment : this.getComments()) {
            ((InternalComment)comment).initialize();
        }
    }

    public void setPermittedOperations(@Nonnull CommentOperations operations) {
        if (this.permittedOperations != null) {
            throw new IllegalStateException("You cannot set permitted operations after they've been initialized");
        }
        this.permittedOperations = operations;
    }

    public void setTasks(@Nonnull List<Task> tasks) {
        if (this.tasks != null) {
            throw new IllegalStateException("You cannot set tasks after they've been initialized");
        }
        this.tasks = tasks;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("author", (Object)this.author).add("text", (Object)StringUtils.abbreviate((String)this.text, (int)20)).toString();
    }

    @Override
    protected boolean hasAttributes() {
        return super.hasAttributes();
    }

    @Override
    protected boolean hasProperties() {
        return super.hasProperties();
    }

    protected boolean hasTasks() {
        return this.tasks != null;
    }

    void addComment(@Nonnull InternalComment comment) {
        this.comments.add(comment);
    }

    void removeComment(@Nonnull InternalComment comment) {
        this.comments.remove(comment);
    }

    private static InternalComment notSelf(Long id, InternalComment comment) {
        if (comment != null && !Objects.equal((Object)comment.getId(), (Object)id)) {
            return comment;
        }
        return null;
    }

    public static class Builder
    extends AbstractPropertySupport.PropertyBuilderSupport<Builder> {
        private InternalStashUser author;
        private Date createdDate;
        private Long id;
        private InternalComment parent;
        private InternalComment root;
        private String text;
        private Date updatedDate;
        private int version;

        public Builder() {
        }

        public Builder(@Nonnull InternalComment comment) {
            super((PropertySupport)Preconditions.checkNotNull((Object)comment, (Object)"comment"));
            this.author = comment.getAuthor();
            this.createdDate = comment.getCreatedDate();
            this.id = comment.getId();
            this.parent = comment.getParent();
            this.root = comment.getRoot();
            this.text = comment.getText();
            this.updatedDate = comment.getUpdatedDate();
            this.version = comment.getVersion();
        }

        @Nonnull
        public Builder author(@Nonnull InternalStashUser value) {
            this.author = (InternalStashUser)Preconditions.checkNotNull((Object)value, (Object)"author");
            return this;
        }

        @Nonnull
        public InternalComment build() {
            if (this.root == null) {
                if (this.parent != null) {
                    this.root = this.parent.getRoot();
                }
            } else if (this.parent == null) {
                this.parent = this.root;
            } else {
                InternalComment expectedRoot = (InternalComment)Objects.firstNonNull((Object)this.parent.getRoot(), (Object)this.parent);
                if (ObjectUtils.notEqual((Object)this.root.getId(), (Object)expectedRoot.getId())) {
                    throw new IllegalStateException("Parent comment [" + this.parent.getId() + "] belongs to root [" + expectedRoot.getId() + "], but root [" + this.root.getId() + "] was set for this comment");
                }
            }
            return new InternalComment(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            this.createdDate = (Date)Preconditions.checkNotNull((Object)value, (Object)"createdDate");
            return this;
        }

        @Nonnull
        public Builder id(@Nullable Long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder parent(@Nullable InternalComment value) {
            this.parent = value;
            return this;
        }

        @Nonnull
        public Builder root(@Nullable InternalComment value) {
            this.root = value;
            return this;
        }

        @Nonnull
        public Builder text(@Nonnull String value) {
            this.text = Builder.checkNotBlank((String)value, (String)"text");
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date value) {
            this.updatedDate = (Date)Preconditions.checkNotNull((Object)value, (Object)"updatedDate");
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

