/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class StashUserAuthenticationToken
extends AbstractAuthenticationToken
implements PermissionGraph {
    private final PermissionGraph elevatedPermissions;
    private final StashUser user;
    private PermissionGraph permissions;

    private StashUserAuthenticationToken(Builder builder) {
        super(Collections.emptySet());
        this.user = builder.user;
        this.elevatedPermissions = builder.elevatedPermissions;
        this.permissions = builder.permissions;
        this.setAuthenticated(true);
    }

    public static StashUserAuthenticationToken forUser(StashUser user) {
        return new Builder().user(user).build();
    }

    @Nonnull
    public StashUserAuthenticationToken copyWithUser(@Nullable StashUser user) {
        return new StashUserAuthenticationToken(new Builder(this).user(user));
    }

    public Object getCredentials() {
        return null;
    }

    public PermissionGraph getElevatedPermissions() {
        return this.elevatedPermissions;
    }

    public String getName() {
        return this.user == null ? "<anonymous>" : this.user.getName();
    }

    public PermissionGraph getPermissions() {
        return this.permissions;
    }

    public StashUser getPrincipal() {
        return this.user;
    }

    @Override
    public boolean isGranted(Permission permission, @Nullable Object resource) {
        return this.isGranted(this.elevatedPermissions, permission, resource) || this.isGranted(this.permissions, permission, resource);
    }

    public void setPermissions(PermissionGraph permissions) {
        this.permissions = permissions;
    }

    private boolean isGranted(PermissionGraph graph, Permission permission, Object resource) {
        return graph != null && permission != null && graph.isGranted(permission, resource);
    }

    public static class Builder {
        private PermissionGraph permissions;
        private PermissionGraph elevatedPermissions;
        private StashUser user;

        public Builder() {
        }

        public Builder(StashUserAuthenticationToken token) {
            this.elevatedPermissions = token.elevatedPermissions;
            this.permissions = token.permissions;
            this.user = token.user;
        }

        public StashUserAuthenticationToken build() {
            return new StashUserAuthenticationToken(this);
        }

        public Builder elevatedPermissions(PermissionGraph value) {
            this.elevatedPermissions = value;
            return this;
        }

        public Builder permissions(PermissionGraph value) {
            this.permissions = value;
            return this;
        }

        public Builder user(StashUser value) {
            this.user = value;
            return this;
        }
    }
}

