/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import com.atlassian.stash.user.StashUserVisitor;
import com.atlassian.stash.user.UserType;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InternalDetailedUser
implements DetailedUser {
    private final InternalStashUser delegate;
    private final String directoryName;
    private final long lastAuthenticationTimestamp;
    private final boolean mutableDetails;
    private final boolean mutableGroups;

    private InternalDetailedUser(Builder builder) {
        this.delegate = builder.delegate;
        this.directoryName = builder.directoryName;
        this.lastAuthenticationTimestamp = builder.lastAuthenticationTimestamp == null ? -1L : builder.lastAuthenticationTimestamp.getTime();
        this.mutableDetails = builder.mutableDetails;
        this.mutableGroups = builder.mutableGroups;
    }

    public <T> T accept(@Nonnull StashUserVisitor<T> visitor) {
        return (T)visitor.visit((DetailedUser)this);
    }

    public boolean equals(Object o) {
        return StashUserEquality.equals((StashUser)this, (Object)o);
    }

    public InternalStashUser getDelegate() {
        return this.delegate;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    @Nonnull
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getEmailAddress() {
        return this.delegate.getEmailAddress();
    }

    public Integer getId() {
        return this.delegate.getId();
    }

    public Date getLastAuthenticationTimestamp() {
        return this.lastAuthenticationTimestamp == -1L ? null : new Date(this.lastAuthenticationTimestamp);
    }

    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    @Nonnull
    public String getSlug() {
        return this.delegate.getSlug();
    }

    @Nonnull
    public UserType getType() {
        return this.delegate.getType();
    }

    public int hashCode() {
        return StashUserEquality.hashCode((StashUser)this);
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public boolean isMutableDetails() {
        return this.mutableDetails;
    }

    public boolean isMutableGroups() {
        return this.mutableGroups;
    }

    public static class Builder {
        private InternalStashUser delegate;
        private String directoryName;
        private Date lastAuthenticationTimestamp;
        private boolean mutableDetails;
        private boolean mutableGroups;

        public Builder(InternalStashUser user) {
            this.delegate = (InternalStashUser)Preconditions.checkNotNull((Object)user, (Object)"user");
        }

        public Builder(InternalDetailedUser user) {
            this.delegate = ((InternalDetailedUser)Preconditions.checkNotNull((Object)user, (Object)"user")).delegate;
            this.directoryName = user.getDirectoryName();
            this.mutableDetails = user.isMutableDetails();
            this.mutableGroups = user.isMutableGroups();
        }

        @Nonnull
        public InternalDetailedUser build() {
            return new InternalDetailedUser(this);
        }

        @Nonnull
        public Builder directoryName(String value) {
            this.directoryName = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder lastAuthenticationTimestamp(@Nullable Date value) {
            this.lastAuthenticationTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder mutableDetails(boolean value) {
            this.mutableDetails = value;
            return this;
        }

        @Nonnull
        public Builder mutableGroups(boolean value) {
            this.mutableGroups = value;
            return this;
        }
    }
}

