/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.RefChangeType;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class InternalRefChange
implements RefChange {
    public static final Function<RefChange, InternalRefChange> TRANSFORM = new Function<RefChange, InternalRefChange>(){

        public InternalRefChange apply(RefChange change) {
            if (change == null || change.getType() == null || StringUtils.isBlank((CharSequence)change.getFromHash()) || StringUtils.isBlank((CharSequence)change.getRefId()) || StringUtils.isBlank((CharSequence)change.getToHash())) {
                return null;
            }
            return new InternalRefChange(change);
        }
    };
    @Column(name="from_hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String fromHash;
    @Column(name="ref_id", nullable=false, length=1024)
    @RequiredString(size=1024)
    private final String refId;
    @Column(name="to_hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String toHash;
    @Column(name="change_type", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.repository.RefChangeType")})
    private final RefChangeType type;

    protected InternalRefChange() {
        this.toHash = null;
        this.refId = null;
        this.fromHash = null;
        this.type = null;
    }

    private InternalRefChange(RefChange change) {
        this.fromHash = change.getFromHash();
        this.refId = change.getRefId();
        this.toHash = change.getToHash();
        this.type = change.getType();
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Nonnull
    public String getRefId() {
        return this.refId;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Nonnull
    public RefChangeType getType() {
        return this.type;
    }
}

