/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermissionVisitor;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.Permission;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.springframework.util.ObjectUtils;

@Entity
@Cacheable
@Table(name="sta_repo_permission", indexes={@Index(name="idx_repo_permission_user", columnList="user_id"), @Index(name="idx_repo_permission_group", columnList="group_name")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalRepositoryPermission
extends InternalGrantedPermission {
    static final String TABLE = "sta_repo_permission";
    @JoinColumn(name="repo_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalRepository repository;

    protected InternalRepositoryPermission() {
        this.repository = null;
    }

    @Override
    public void accept(@Nonnull InternalGrantedPermissionVisitor visitor) {
        visitor.visit(this);
    }

    private InternalRepositoryPermission(Long id, Permission permission, InternalRepository repository, String group, InternalStashUser user) {
        super(id, permission, group, user);
        this.repository = repository;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalRepositoryPermission) {
            InternalRepositoryPermission that = (InternalRepositoryPermission)o;
            return ObjectUtils.nullSafeEquals((Object)this.getPermission(), (Object)that.getPermission()) && ObjectUtils.nullSafeEquals((Object)this.getGroup(), (Object)that.getGroup()) && ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)that.getId()) && ObjectUtils.nullSafeEquals((Object)this.getRepository(), (Object)that.getRepository()) && ObjectUtils.nullSafeEquals((Object)this.getUser(), (Object)that.getUser());
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object[])new Object[]{this.getPermission(), this.getGroup(), this.getId(), this.getRepository(), this.getUser()});
    }

    public static final class Builder
    extends InternalGrantedPermission.AbstractBuilder<Builder> {
        private InternalRepository repository;

        public Builder() {
        }

        public Builder(InternalRepositoryPermission source) {
            super(source);
            this.repository = source.getRepository();
        }

        public InternalRepositoryPermission build() {
            return new InternalRepositoryPermission(this.id, this.permission, this.repository, this.group, this.user);
        }

        public Builder repository(InternalRepository repository) {
            this.repository = repository;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

