/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.activity.InternalActivity;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.pull.PullRequestActivity;
import com.atlassian.stash.pull.PullRequestActivityVisitor;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@DiscriminatorValue(value="1")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_sta_pr_activity_id"))
@Table(name="sta_pr_activity", indexes={@Index(name="idx_sta_pr_activity", columnList="pr_id, pr_action")})
public class InternalPullRequestActivity
extends InternalActivity
implements PullRequestActivity {
    public static final String TABLE = "sta_pr_activity";
    @Column(name="pr_action", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.pull.PullRequestAction")})
    private final PullRequestAction action;
    @JoinColumn(name="pr_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_activity_pr"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;

    protected InternalPullRequestActivity() {
        this.action = null;
        this.pullRequest = null;
    }

    protected InternalPullRequestActivity(AbstractPullRequestActivityBuilder<?, ?> builder) {
        super(builder);
        this.action = ((AbstractPullRequestActivityBuilder)builder).action;
        this.pullRequest = ((AbstractPullRequestActivityBuilder)builder).pullRequest;
    }

    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestActivity)this);
    }

    @Nonnull
    public PullRequestAction getAction() {
        return this.action;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Override
    public void initialize() {
        super.initialize();
        HibernateUtils.initialize(this.getPullRequest());
    }

    protected static abstract class AbstractPullRequestActivityBuilder<B extends AbstractPullRequestActivityBuilder<B, A>, A extends InternalPullRequestActivity>
    extends InternalActivity.AbstractActivityBuilder<B, A> {
        private final InternalPullRequest pullRequest;
        private PullRequestAction action;

        protected AbstractPullRequestActivityBuilder(@Nonnull InternalPullRequest pullRequest) {
            this.pullRequest = (InternalPullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
        }

        protected AbstractPullRequestActivityBuilder(@Nonnull InternalPullRequestActivity activity) {
            super(activity);
            this.action = activity.getAction();
            this.pullRequest = activity.getPullRequest();
        }

        @Nonnull
        public B action(PullRequestAction value) {
            this.action = value;
            return (B)((Object)((AbstractPullRequestActivityBuilder)((Object)this.self())));
        }
    }

    public static class Builder
    extends AbstractPullRequestActivityBuilder<Builder, InternalPullRequestActivity> {
        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
        }

        public Builder(@Nonnull InternalPullRequestActivity activity) {
            super(activity);
        }

        @Override
        @Nonnull
        public InternalPullRequestActivity build() {
            return new InternalPullRequestActivity(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

