/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.validation.ProjectKeyUnique;
import com.atlassian.stash.internal.validation.ProjectNameUnique;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.validation.ConstraintNature;
import com.atlassian.stash.validation.groups.Create;
import com.atlassian.stash.validation.groups.Update;
import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.springframework.util.ObjectUtils;

@Cacheable
@DiscriminatorColumn(name="project_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@ProjectKeyUnique(groups={Create.class, Update.class}, payload={ConstraintNature.Conflict.class})
@ProjectNameUnique(groups={Create.class, Update.class}, payload={ConstraintNature.Conflict.class})
@Table(name="project", indexes={@Index(name="idx_project_key", columnList="project_key"), @Index(name="idx_project_name", columnList="name"), @Index(name="idx_project_type", columnList="project_type")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalProject
implements Initializable,
Project {
    private static final String ID_GEN = "projectIdGenerator";
    static final String TABLE = "project";
    @Column(name="description")
    private final String description;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="projectIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="projectIdGenerator", table="id_sequence", pkColumnValue="project", allocationSize=20)
    private final Integer id;
    @Column(name="project_key", unique=true)
    private final String key;
    @Column(name="name", unique=true)
    private final String name;
    @Column(name="project_type", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.project.ProjectType")})
    private final ProjectType type;

    protected InternalProject() {
        this.description = null;
        this.id = null;
        this.key = null;
        this.name = null;
        this.type = ProjectType.NORMAL;
    }

    protected InternalProject(Integer id, String key, String name, String description, ProjectType type) {
        this.description = description;
        this.id = id;
        this.key = StringUtils.upperCase((String)StringUtils.trimToNull((String)StringUtils.defaultString((String)key, (String)name)), (Locale)Locale.US);
        this.name = StringUtils.trimToNull((String)name);
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalProject) {
            InternalProject that = (InternalProject)o;
            return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)that.getId());
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public ProjectType getType() {
        return this.type;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.getId());
    }

    @Override
    public void initialize() {
    }

    public String toString() {
        return "Project{id=" + this.id + ", key='" + this.key + "', name='" + this.name + "'}";
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected Integer id;

        public AbstractBuilder() {
        }

        public AbstractBuilder(@Nonnull Project project) {
            this.id = ((Project)Preconditions.checkNotNull((Object)project, (Object)InternalProject.TABLE)).getId();
        }

        public B id(Integer value) {
            this.id = value;
            return this.self();
        }

        protected abstract B self();
    }
}

