/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.validation.RequiredString;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="sta_configured_hook_status", indexes={@Index(name="idx_sta_config_hook_status_pk", columnList="repo_id, hookkey, enabled")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_config_hook_status_key", columnNames={"repo_id", "hookkey"})})
public class InternalRepositoryHookStatus {
    static final String TABLE = "sta_configured_hook_status";
    static final String ID_GEN = "configuredHookStatusIdGenerator";
    @JoinColumn(name="repo_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalRepository repository;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="configuredHookStatusIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_configured_hook_status", name="configuredHookStatusIdGenerator", table="id_sequence")
    private final Integer id;
    @Column(name="hookkey")
    @RequiredString(size=255)
    private final String key;
    @Column(name="enabled", nullable=false)
    private final boolean enabled;

    protected InternalRepositoryHookStatus() {
        this(null, null, null, false);
    }

    private InternalRepositoryHookStatus(Integer id, InternalRepository repository, String key, boolean enabled) {
        this.id = id;
        this.repository = repository;
        this.key = key;
        this.enabled = enabled;
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Integer getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalRepositoryHookStatus that = (InternalRepositoryHookStatus)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public static class Builder {
        private Integer id;
        private String key;
        private InternalRepository repo;
        private boolean enabled;

        public Builder() {
        }

        public Builder(InternalRepositoryHookStatus settings) {
            this.id = settings.getId();
            this.key = settings.getKey();
            this.repo = settings.getRepository();
            this.enabled = settings.isEnabled();
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder repo(InternalRepository repo) {
            this.repo = repo;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public InternalRepositoryHookStatus build() {
            return new InternalRepositoryHookStatus(this.id, this.repo, this.key, this.enabled);
        }
    }
}

