/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class StashUserAuthenticationToken
extends AbstractAuthenticationToken {
    private final Set<Permission> runWithPermissions;
    private final StashUser user;
    private PermissionGraph permissionGraph;

    public StashUserAuthenticationToken(StashUser user) {
        this(user, Collections.emptySet());
    }

    public StashUserAuthenticationToken(StashUser user, PermissionGraph graph) {
        this(user);
        this.permissionGraph = graph;
    }

    public StashUserAuthenticationToken(StashUser user, Permission runWithPermission) {
        this(user, Collections.singleton(runWithPermission));
    }

    public StashUserAuthenticationToken(StashUser user, Set<Permission> runWithPermissions) {
        super(Collections.emptyList());
        this.user = user;
        this.runWithPermissions = runWithPermissions == null ? ImmutableSet.of() : ImmutableSet.copyOf(runWithPermissions);
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return null;
    }

    public String getName() {
        return this.user == null ? "<anonymous>" : this.user.getName();
    }

    public PermissionGraph getPermissionGraph() {
        return this.permissionGraph;
    }

    public StashUser getPrincipal() {
        return this.user;
    }

    public Set<Permission> getRunWithPermissions() {
        return this.runWithPermissions;
    }

    public void setPermissionGraph(PermissionGraph permissionGraph) {
        this.permissionGraph = permissionGraph;
    }
}

