/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.text.Normalizer;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@Entity
@Table(name="stash_user")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalStashUser
implements StashUser,
Serializable {
    public static final String ID_GEN = "userIdGenerator";
    public static final int MAX_GENERATED_SLUG_LENGTH = 126;
    public static final int MAX_NAME_LENGTH = 255;
    public static final int MAX_SLUG_RETRY_COUNT = 10;
    public static final String TABLE = "stash_user";
    @Id
    @GeneratedValue(generator="userIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="userIdGenerator", table="id_sequence", pkColumnValue="stash_user", allocationSize=50)
    private final Integer id;
    @Column(name="name", nullable=false, unique=true)
    @RequiredString(size=255)
    private final String username;
    @Column(name="slug", nullable=false, unique=true)
    private final String slug;
    @Transient
    private volatile transient User backingCrowdUser;

    protected InternalStashUser() {
        this.backingCrowdUser = null;
        this.id = null;
        this.slug = null;
        this.username = null;
    }

    protected InternalStashUser(Integer id, String name, String slug, User backingCrowdUser) {
        this.id = id;
        this.username = IdentifierUtils.toLowerCase((String)name);
        this.slug = slug == null ? InternalStashUser.slugify(name) : slug;
        this.backingCrowdUser = backingCrowdUser;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        return StashUserEquality.equals((StashUser)this, (Object)o);
    }

    public User getBackingCrowdUser() {
        return this.backingCrowdUser;
    }

    @Nonnull
    public String getDisplayName() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getDisplayName() : this.username;
    }

    public String getEmailAddress() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getEmailAddress() : null;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.backingCrowdUser != null ? this.backingCrowdUser.getName() : this.username;
    }

    public String getUsername() {
        return this.username;
    }

    public int hashCode() {
        return StashUserEquality.hashCode((StashUser)this);
    }

    public boolean isActive() {
        return this.backingCrowdUser != null && this.backingCrowdUser.isActive();
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    public boolean isCrowdBacked() {
        return this.backingCrowdUser != null;
    }

    public void setBackingCrowdUser(User crowdUser) {
        if (this.backingCrowdUser != null) {
            throw new IllegalStateException("You cannot set the backing Crowd user after it's been initialized");
        }
        this.backingCrowdUser = crowdUser;
    }

    public String toString() {
        return "InternalStashUser{id=" + this.id + ", name='" + this.username + "', slug='" + this.slug + "'}";
    }

    public static String generateSlug(SecureTokenGenerator tokenGenerator) {
        String slug = tokenGenerator.generateToken();
        if (slug.length() > 127) {
            slug = slug.substring(0, 127);
        }
        return slug;
    }

    public static String slugify(String name) {
        String slug = Normalizer.normalize(name, Normalizer.Form.NFKD).replaceAll("[:/?#@!$&'()*+,;=%\\\\\\[\\]]", "_");
        if (slug.length() > 126) {
            slug = slug.substring(0, 126);
        }
        return IdentifierUtils.toLowerCase((String)slug);
    }

    public static class Builder {
        private User crowdUser;
        private Integer id;
        private String name;
        private String slug;

        public Builder() {
        }

        public Builder(InternalStashUser user) {
            this.crowdUser = user.getBackingCrowdUser();
            this.id = user.getId();
            this.name = user.getName();
            this.slug = user.getSlug();
        }

        public InternalStashUser build() {
            return new InternalStashUser(this.id, this.name, this.slug, this.crowdUser);
        }

        public Builder crowdUser(User value) {
            this.crowdUser = value;
            return this;
        }

        public Builder id(Integer value) {
            this.id = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            this.slug = InternalStashUser.slugify(value);
            return this;
        }

        public Builder slug(String value) {
            this.slug = Builder.checkSlug(value);
            return this;
        }

        public Builder regenerateSlug() {
            this.slug = null;
            return this;
        }

        private static String checkSlug(String slug) {
            Preconditions.checkNotNull((Object)slug, (Object)"slug");
            Preconditions.checkArgument((!slug.trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank slug is required");
            Preconditions.checkArgument((slug.length() <= 127 ? 1 : 0) != 0, (Object)"The provided slug exceeds the maximum allowed length");
            String check = InternalStashUser.slugify(slug);
            if (slug.length() < 127) {
                Preconditions.checkArgument((boolean)slug.equals(check), (String)"The provided slug is not valid (%s != %s)", (Object[])new Object[]{slug, check});
            } else if (slug.length() == 127) {
                Preconditions.checkArgument((slug.startsWith(check) && Character.isDigit(slug.charAt(126)) ? 1 : 0) != 0, (String)"The provided slug is not valid (%s != %s with a trailing digit)", (Object[])new Object[]{slug, check});
            }
            return slug;
        }
    }
}

