/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermissionVisitor;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.user.Permission;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.springframework.util.ObjectUtils;

@Entity
@Cacheable
@Table(name="sta_project_permission")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@org.hibernate.annotations.Table(appliesTo="sta_project_permission", indexes={@Index(name="idx_project_permission_user", columnNames={"user_id"}), @Index(name="idx_project_permission_group", columnNames={"group_name"})})
public class InternalProjectPermission
extends InternalGrantedPermission {
    static final String TABLE = "sta_project_permission";
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalProject project;

    protected InternalProjectPermission() {
        this.project = null;
    }

    @Override
    public void accept(@Nonnull InternalGrantedPermissionVisitor visitor) {
        visitor.visit(this);
    }

    private InternalProjectPermission(Long id, Permission permission, InternalProject project, String group, InternalStashUser user) {
        super(id, permission, group, user);
        this.project = project;
    }

    @Nonnull
    public InternalProject getProject() {
        return this.project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalProjectPermission) {
            InternalProjectPermission that = (InternalProjectPermission)o;
            return ObjectUtils.nullSafeEquals((Object)this.getPermission(), (Object)that.getPermission()) && ObjectUtils.nullSafeEquals((Object)this.getGroup(), (Object)that.getGroup()) && ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)that.getId()) && ObjectUtils.nullSafeEquals((Object)this.getProject(), (Object)that.getProject()) && ObjectUtils.nullSafeEquals((Object)this.getUser(), (Object)that.getUser());
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object[])new Object[]{this.getPermission(), this.getGroup(), this.getId(), this.getProject(), this.getUser()});
    }

    public static final class Builder
    extends InternalGrantedPermission.AbstractBuilder<Builder> {
        private InternalProject project;

        public Builder() {
        }

        public Builder(InternalProjectPermission source) {
            super(source);
            this.project = source.getProject();
        }

        public InternalProjectPermission build() {
            return new InternalProjectPermission(this.id, this.permission, this.project, this.group, this.user);
        }

        public Builder project(InternalProject project) {
            this.project = project;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

