/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="app_property")
public class ApplicationProperty {
    static final int MAX_VALUE_SIZE = 2000;
    @Id
    @Column(name="prop_key")
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.internal.server.ApplicationProperty$Key")})
    private final Key key;
    @Column(name="prop_value", nullable=false)
    @RequiredString(size=2000)
    private final String value;

    protected ApplicationProperty() {
        this.key = null;
        this.value = null;
    }

    public ApplicationProperty(@Nonnull Key key, @Nonnull String value) {
        this.key = (Key)((Object)Preconditions.checkNotNull((Object)((Object)key)));
        this.value = (String)Preconditions.checkNotNull((Object)value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationProperty)) {
            return false;
        }
        ApplicationProperty property = (ApplicationProperty)o;
        return this.key == property.key && this.value.equals(property.value);
    }

    public Key getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "ApplicationProperty{key=" + (Object)((Object)this.key) + ", value='" + this.value + '\'' + '}';
    }

    public static enum Key {
        NAME("instance.name"),
        AVATAR_SOURCE("avatar.source"),
        BASE_URL("instance.url"),
        EMAIL_ADDRESS("mail.sender.address"),
        LAST_HOME("instance.home"),
        LICENSE("license"),
        SERVER_ID("server.id"),
        MAIL_HOST("mail.host"),
        MAIL_HOST_PORT("mail.port"),
        MAIL_HOST_USERNAME("mail.username"),
        MAIL_HOST_PASSWORD("mail.password"),
        MAIL_USE_TLS("mail.useTls"),
        ALLOW_PUBLIC_SIGNUP("auth.public.signup"),
        REQUIRE_CAPTCHA_ON_SIGNUP("auth.captcha.signup"),
        MAX_CAPTCHA_ATTEMPTS("auth.max.captcha"),
        SETUP_COMPLETED("setup.completed"),
        DEBUG_LOGGING_ENABLED("logging.debug.enabled"),
        PROFILING_ENABLED("profiling.enabled");

        private final String id;

        private Key(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Key fromId(String id) {
            for (Key key : Key.values()) {
                if (!key.id.equals(id)) continue;
                return key;
            }
            throw new IllegalArgumentException("No ApplicationProperty.Key matches the ID [" + id + "]");
        }
    }
}

