/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.InternalRescopeDetails;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.pull.PullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestRescopeActivity;
import com.atlassian.stash.pull.RescopeDetails;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@DiscriminatorValue(value="4")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id")
@Table(name="sta_pr_rescope_activity")
public class InternalPullRequestRescopeActivity
extends InternalPullRequestActivity
implements PullRequestRescopeActivity {
    public static final String TABLE = "sta_pr_rescope_activity";
    @Transient
    private InternalRescopeDetails added;
    @CollectionTable(name="sta_pr_rescope_commit", joinColumns={@JoinColumn(name="activity_id", nullable=false)})
    @ElementCollection
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<InternalPullRequestRescopeCommit> commits;
    @Column(name="from_hash", nullable=false, length=40)
    @RequiredString(size=40)
    private final String fromHash;
    @Column(name="prev_from_hash", nullable=false, length=40)
    @RequiredString(size=40)
    private final String previousFromHash;
    @Column(name="prev_to_hash", nullable=false, length=40)
    @RequiredString(size=40)
    private final String previousToHash;
    @Transient
    private InternalRescopeDetails removed;
    @Column(name="to_hash", nullable=false, length=40)
    @RequiredString(size=40)
    private final String toHash;
    @Column(name="commits_added")
    private final Integer totalAdded;
    @Column(name="commits_removed")
    private final Integer totalRemoved;

    protected InternalPullRequestRescopeActivity() {
        this.added = this.removed = InternalRescopeDetails.EMPTY;
        this.commits = Sets.newHashSet();
        this.toHash = null;
        this.previousToHash = null;
        this.previousFromHash = null;
        this.fromHash = null;
        this.totalRemoved = null;
        this.totalAdded = null;
    }

    private InternalPullRequestRescopeActivity(Long id, Date createdDate, InternalStashUser user, PullRequestAction action, InternalPullRequest pullRequest, String fromHash, String toHash, String previousFromHash, String previousToHash, Set<InternalPullRequestRescopeCommit> commits, Integer totalAdded, Integer totalRemoved) {
        super(id, createdDate, user, action, pullRequest);
        this.commits = commits;
        this.fromHash = fromHash;
        this.previousFromHash = previousFromHash;
        this.previousToHash = previousToHash;
        this.toHash = toHash;
        this.totalAdded = totalAdded;
        this.totalRemoved = totalRemoved;
        this.added = this.removed = InternalRescopeDetails.EMPTY;
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestRescopeActivity)this);
    }

    @Nonnull
    public RescopeDetails getAdded() {
        return this.added;
    }

    public Set<InternalPullRequestRescopeCommit> getCommits() {
        return this.commits;
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Nonnull
    public String getPreviousFromHash() {
        return this.previousFromHash;
    }

    @Nonnull
    public String getPreviousToHash() {
        return this.previousToHash;
    }

    @Nonnull
    public RescopeDetails getRemoved() {
        return this.removed;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public int getTotalAdded() {
        return this.totalAdded == null ? 0 : this.totalAdded;
    }

    public int getTotalRemoved() {
        return this.totalRemoved == null ? 0 : this.totalRemoved;
    }

    public boolean isPrecalculated() {
        return this.totalAdded != null;
    }

    public void setAdded(InternalRescopeDetails value) {
        if (this.added != InternalRescopeDetails.EMPTY) {
            throw new IllegalStateException("You cannot set the added details after they've been initialized");
        }
        this.added = value;
    }

    public void setRemoved(InternalRescopeDetails value) {
        if (this.removed != InternalRescopeDetails.EMPTY) {
            throw new IllegalStateException("You cannot set the removed details after they've been initialized");
        }
        this.removed = value;
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder> {
        private final ImmutableSet.Builder<InternalPullRequestRescopeCommit> commits = ImmutableSet.builder();
        private String fromHash;
        private String previousFromHash;
        private String previousToHash;
        private String toHash;
        private Integer totalAdded;
        private Integer totalRemoved;

        public Builder() {
            this.action(PullRequestAction.RESCOPED);
        }

        public Builder(InternalPullRequestRescopeActivity activity) {
            super(activity);
            this.fromHash = activity.getFromHash();
            this.previousFromHash = activity.getPreviousFromHash();
            this.previousToHash = activity.getPreviousToHash();
            this.toHash = activity.getToHash();
            this.totalAdded = activity.getTotalAdded();
            this.totalRemoved = activity.getTotalRemoved();
        }

        public InternalPullRequestRescopeActivity build() {
            return new InternalPullRequestRescopeActivity(this.id, this.createdDate, this.user, this.action, this.pullRequest, this.fromHash, this.toHash, this.previousFromHash, this.previousToHash, (Set)this.commits.build(), this.totalAdded, this.totalRemoved);
        }

        public Builder commit(InternalPullRequestRescopeCommit value) {
            return this.commits(value, new InternalPullRequestRescopeCommit[0]);
        }

        public Builder commits(InternalPullRequestRescopeCommit value, InternalPullRequestRescopeCommit ... values) {
            this.commits.add((Object)value).add((Object[])values);
            return this.self();
        }

        public Builder commits(Iterable<InternalPullRequestRescopeCommit> value) {
            this.commits.addAll(value);
            return this.self();
        }

        public Builder fromHash(String value) {
            this.fromHash = value;
            return this.self();
        }

        public Builder previousFromHash(String value) {
            this.previousFromHash = value;
            return this.self();
        }

        public Builder previousToHash(String value) {
            this.previousToHash = value;
            return this.self();
        }

        public Builder toHash(String value) {
            this.toHash = value;
            return this.self();
        }

        public Builder totalAdded(int value) {
            this.totalAdded = value;
            return this.self();
        }

        public Builder totalRemoved(int value) {
            this.totalRemoved = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

