/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.pull.PullRequestRef;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.validation.RequiredString;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Embeddable
public class InternalPullRequestRef
implements Initializable,
PullRequestRef {
    @Column(name="branch_name", nullable=false, length=1024)
    @RequiredString(size=1024)
    private final String displayId;
    @Column(name="hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String hash;
    @Column(name="branch_fqn", nullable=false, length=1024)
    @RequiredString(size=1024)
    private final String id;
    @JoinColumn(name="repository_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;

    protected InternalPullRequestRef() {
        this.id = null;
        this.hash = null;
        this.displayId = null;
    }

    private InternalPullRequestRef(InternalRepository repository, String id, String displayId, String hash) {
        this.displayId = displayId;
        this.hash = hash;
        this.id = id;
        this.repository = repository;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getDisplayId() {
        return this.displayId;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getLatestChangeset() {
        return this.hash;
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
    }

    public String toString() {
        return this.getRepository().getProject().getKey() + "/" + this.getRepository().getSlug() + ":" + this.getId();
    }

    public static class Builder {
        private String displayId;
        private String hash;
        private String id;
        private InternalRepository repository;

        public Builder() {
        }

        public Builder(InternalPullRequestRef ref) {
            this.displayId = ref.getDisplayId();
            this.hash = ref.getLatestChangeset();
            this.id = ref.getId();
            this.repository = ref.getRepository();
        }

        public InternalPullRequestRef build() {
            return new InternalPullRequestRef(this.repository, this.id, this.displayId, this.hash);
        }

        public Builder displayId(String value) {
            this.displayId = value;
            return this;
        }

        public Builder hash(String value) {
            this.hash = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder ref(Ref value) {
            this.displayId = value.getDisplayId();
            this.hash = value.getLatestChangeset();
            this.id = value.getId();
            return this;
        }

        public Builder repository(InternalRepository value) {
            this.repository = value;
            return this;
        }
    }
}

