/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.stash.util.CustomPreconditions;
import com.atlassian.stash.validation.RequiredString;
import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@IdClass(value=CompositeKey.class)
@Table(name="plugin_setting")
public class PluginSetting {
    @Column(name="namespace", nullable=false)
    @Id
    @RequiredString(size=255)
    private final String namespace;
    @Column(name="key_name", nullable=false)
    @Id
    @RequiredString(size=255)
    private final String key;
    @Column(name="key_value", nullable=false)
    @Lob
    @RequiredString(size=0x7FFFFFFF)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String value;

    protected PluginSetting() {
        this.namespace = null;
        this.key = null;
        this.value = null;
    }

    public PluginSetting(String namespace, String key, String value) {
        CustomPreconditions.checkRequiredString((String)namespace, (int)255);
        CustomPreconditions.checkRequiredString((String)key, (int)255);
        CustomPreconditions.checkRequiredString((String)value);
        this.key = key;
        this.value = value;
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static class CompositeKey
    implements Serializable {
        String namespace;
        String key;

        public CompositeKey() {
            this(null, null);
        }

        public CompositeKey(String namespace, String key) {
            this.namespace = namespace;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return !(this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null);
        }

        public int hashCode() {
            int result = this.namespace != null ? this.namespace.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }
    }
}

